/**
*   । 樨  ଠ樨    ࠭.
*
* 	1.5	(C)Copyright InfoScope Inc. 1992
*
**/

#include <stdio.h>

#include <display.h>

#include "life.h"
#include "lifescr.h"

WIN_DEF DEF_STATISTICS = {
   {80,1},
   dsp_doAttr(DSP_LIGHTGRAY,DSP_BLACK),
   0,
   0
};

LOC WHERE_STATISTICS = {1,25};

long scrX, scrY;
long scrOldX, scrOldY;
WINDOW *statistics_wnd;

LOCAL void clsPage (char ch, byte attr);
LOCAL void putChar (char ch, byte attr, int x, int y);

/**
*
*  putChar	-- 뢮 ᨬ    ࠭ 묨 梥⠬
*
* 饭	putChar(ch, attr, x, y);
*
*		char ch		뢮 ᨬ
*		byte attr	梥  ଠ 
*		int x		न  ࠭  ਧ⠫
*		int y		 ⨪
*
* ᠭ	뢮 ᨬ ch  ਡ⠬ attr    ࠭
*		 न⠬ (x, y).
*
* 頥	void	.. 祣.
*
**/
LOCAL void putChar(char ch, byte attr, int x, int y)
{
   scr_PutChar(utl_GetLoc(x,y),dsp_getFore(attr),dsp_getBack(attr),ch,0);
}/*putChar*/

/**
*
*  clsPage	--  ࠭  ᨬ
*
* 饭	clsPage(ch, attr);
*
*		char ch		ᨬ
*		byte attr	ਡ
*
* ᠭ	 ࠭ ᨬ ch  梥⠬ attr.
*
* 頥	void	.. 祣.
*
**/
LOCAL void clsPage(char ch, byte attr)
{
   int x,y;

   for(x=1;x<=dsp_ScreenCols();x++)
      for(y=1;y<=dsp_ScreenRows();y++)
         putChar(ch,attr,x,y);
}/*clsPage*/

/**
*
*  drawLand	--   䨣
*
* 饭	drawLand();
*
* ᠭ	  䨣 祪,  
*		 .
*
* 頥	void	.. 祣.
*
**/
ENTRY void drawLand(void)
{
   CELL *current;

   clsPage (EMPTY_SYM, EMPTY_ATTR);
   for (current = mainList; current != NULL; current = current->next) {
      showCell (current);
   }
}/*drawLand*/

/**
*
*  ReDraw	-- ᮢ뢠 䨣
*
* 饭	ReDraw();
*
* ᠭ	  窨, 訥  ࠭,  ᮮ⢥⢨
*		 묨 ⭮⥫묨 न⠬ ࠭ 
*		᪮ (ScrOldX, ScrOldY),  ⮬ 뢮 
*		 묨 ⭮⥫묨 न⠬ (ScrX, ScrY).
*
* 頥	void	.. 祣.
*
**/
ENTRY void ReDraw (void)
{
   long newx, newy;
   CELL *current;

   newx = scrX;
   newy = scrY;
   scrX = scrOldX;
   scrY = scrOldY;
   for (current = mainList; current != NULL; current = current->next) {
      hideCell (current);
   }
   scrX = newx;
   scrY = newy;
   for (current = mainList; current != NULL; current = current->next) {
      showCell (current);
   }
   scrOldX = scrX;
   scrOldY = scrY;
}/*ReDraw*/

/**
*
*  hideCell	--  , ᫨  
*
* 饭	hideCell(cell);
*
*		CELL *cell	 窠
*
* ᠭ	᫨ 窠 cell 室   ,
*		뢮    ᮮ⢥騬 ⭮⥫묨
*		न⠬ ࠭ "䮭" ᨬ EMPTY_SYM
*		梥⮬ EMPTY_ATTR,  ⨢ 砥 祣  .
*
* ਬ砭	⭮⥫ न  ᫮
*		⭮⥫ न ࠭  ᪮ 
*		न⠬ 窨:
*
*		    (cell->loc.x + ScrX, cell->loc.y + ScrY).
*
* 頥	void	.. 祣.
*
**/
void hideCell (CELL *cell)
{
   if ((cell->loc.x + scrX >= 1) && (cell->loc.x + scrX <= dsp_ScreenCols ()) &&
        (cell->loc.y + scrY >= 1) && (cell->loc.y + scrY <= dsp_ScreenRows ()))
      putChar (EMPTY_SYM, EMPTY_ATTR, (int) (cell->loc.x + scrX), (int) (cell->loc.y + scrY));
}/*hideCell*/

/**
*
*  showCell	-- 뢠 , ᫨  
*
* 饭	showCell(cell);
*
*		CELL *cell	 窠
*
* ᠭ	᫨ 窠 cell 室   ,
*		뢮    ᮮ⢥騬 ⭮⥫묨
*		न⠬ ࠭ "⨢" ᨬ CELL_SYM
*		梥⮬ CELL_ATTR,  ⨢ 砥 祣  .
*
* ਬ砭	ᠭ ⭮⥫ न .  hideCell.
*
* 頥	void	.. 祣.
*
**/
void showCell (CELL *cell)
{
   if ((cell->loc.x + scrX >= 1) && (cell->loc.x + scrX <= dsp_ScreenCols ()) &&
        (cell->loc.y + scrY >= 1) && (cell->loc.y + scrY <= dsp_ScreenRows ()))
      putChar (CELL_SYM, CELL_ATTR, (int) (cell->loc.x + scrX), (int) (cell->loc.y + scrY));
}/*showCell*/

void OutStatistics(char *mode)
{
   char str[80];
   		/* 㥬  १.	*/
   wnd_SetPos (statistics_wnd, 1, 1);
   sprintf (str, ": %6ld 祪: %6ld", stepNo, listLen ());
   wnd_PutStr (statistics_wnd, utl_GetLoc(1,1), str, 0, DSP_LIGHTGRAY, DSP_BLACK, 0);
   wnd_PutStr (statistics_wnd, utl_GetLoc(dsp_ScreenCols() - 26,1),
         "                        ", 0, DSP_LIGHTGRAY, DSP_BLACK, 0);
   wnd_PutStr (statistics_wnd, utl_GetLoc(dsp_ScreenCols() - strlen(mode) - 2,1),
   		mode, 0, DSP_LIGHTGRAY, DSP_BLACK, 0);
}/*OutStatistics*/

void StartStatisticsOut(void)
{
   WHERE_STATISTICS.y = dsp_ScreenRows();
   statistics_wnd = wnd_Open (&DEF_STATISTICS, &WHERE_STATISTICS,
               pc_GetVideoPage(), 0);
}/*StartStatisticsOut*/

void HideStatisticsWnd(void)
{
   wnd_Hide(statistics_wnd);
}/*HideStatisticsWnd*/

void ShowStatisticsWnd(void)
{
   wnd_UnHide(statistics_wnd);
}/*HideStatisticsWnd*/
