/**
*  ᯥ稢  ⥪饩 樨  䠩 
*	⥭ 樨  䠩.
*
* 	1.5	(C)Copyright InfoScope Inc. 1992
*
**/


#include <dir.h>
#include <stdio.h>
#include <conio.h>

#include <display.h>
#include <kbdcodes.h>
#include <wnfrdef.h>

#include "life_io.h"
#include "lifescr.h"
#include "life.h"
#include "lifetxt.h"
#include "filemenu.h"

LOCAL void saveToFile (FILE *outF);
LOCAL void makeBak (char *name);

FILE *wFile;

WIN_DEF LIFE_IO0 = {
   {44,3},
   dsp_doAttr(DSP_BLUE,DSP_LIGHTGRAY),
   1,		/*  !		*/
   1,		/*   !	*/

    {	/*  ࠬ:   ,			*/
    	/*	孨    業஢		*/
    WN_UPDBL | WN_RDBL | WN_DWNDBL | WN_LDBL | WN_UPHC | WN_DWNHC,
    dsp_doAttr(DSP_WHITE,DSP_DARKGRAY),	/*  ਡ	*/
    '#',
    NULL,		/* 孨 	*/
    dsp_doAttr(DSP_WHITE,DSP_DARKGRAY),	/*   ਡ	*/
    " ESC - 室  롮 ",
    dsp_doAttr(DSP_WHITE,DSP_DARKGRAY),
    NULL,
    dsp_doAttr(DSP_WHITE,DSP_DARKGRAY),
    NULL,
    dsp_doAttr(DSP_WHITE,DSP_DARKGRAY)
    }
};

LOC LIFE_IOH0 = {1,6};

/**
*
*  readFile -- ⥭ 䨣樨  䠩
*
* 饭	result = readFile(filename);
*
*		int result	1, ᫨   浪,
*				0, ᫨ 䠩  㤠 .
*		char *filename   䠩.
*
* ᠭ	䨣   ⥪⮢ 
*		᫥⥫쭮 ப,   
*		ᮤন : x-  y-न 窨 
*		᪮. 筮, न   
*		⥫묨, ⠪  ⥫묨.
*
*		 १ ࠡ 㭪樨 㤥 ஥ ᯨ᮪
*		   mainList, ᮤঠ騩 न 祪 
*		䠩.
*
*		᫨   । 窨  ᯨ᮪  墠⨫
*		, 㭪 뢠 finMessage  ᮮ饭 noMemoryMsg.
*		,  ᫥ ⮣ 믮 ணࠬ ४
*		   -1.
*
*		 ६ ⥭   業 殮
*		樨. 祭 meanX  meanY ८ࠧ 
*		न 業 殮   - 祪.
*		⮬ 業 殮 ⠭ 業஬ ᪮ (ScrX,ScrY)
*		 業஬ ࠭.
*
*	ਬ.	࠭塞 ScrOldX  ScrOldY ᯮ  㭪樨 ReDraw
*		 ⮣, ⮡   ࠭ ⥪ .
*
* 頥	result	1, ᫨   浪,
*			0, ᫨ 䠩  㤠 .
*
**/

ENTRY int readFile(char *name)
{
   char str[80];
   long x, y, i;
   long meanX=0, meanY=0;

   if((wFile = fopen(name,"rt")) == NULL)
      return 0;

   wipeLand();
   meanX = meanY = i = 0;
   while (fgets (str, 80, wFile)) {
      sscanf (str, "%ld %ld", &x, &y);
      if(!addCell (x, y, &mainList))
         finMessage(noMemoryMsg);
      meanX += x;
      meanY += y;
      i++;
   }

   if(i) {
      meanX /= i;
      meanY /= i;
   }
   scrX = pc_GetScreenCols () / 2;
   scrX -= meanX;
   scrOldX = scrX;
   scrY = pc_GetScreenRows () / 2;
   scrY -= meanY;
   scrOldY = scrY;
   return 1;
}/*readFile*/

/**
*
*  askFileName	-- 訢  짮⥫  䠩
*
* 饭	ret = askFileName(char *name,int save)
*
*		int ret		頥: 1, ᫨  筮
*				0, ᫨ 짮⥫   <ESC>
*		char *name	 䠩. ᫨ ப  
*				室, 짮⥫ । .
*				 ⨢ 砥, 짮⥫
*				  䠩  ᠬ 砫.
*				᫨ 짮⥫  <ESC>, 
*				 室 ப name  (⠪
*				᢮⢮ 㭪樨 wnd_LinEd).
*		int save	ࠢ 孨  :
*				1 -   "Enter file name to save to",
*				0 -   "Enter file name to load from".
*
* ᠭ	 , 뢮, ।㥬, 頥.
*
* 頥	ret		頥: 1, ᫨  筮
*				0, ᫨ 짮⥫   <ESC>
*
**/
LOCAL int askFileName(char *name,int save)
{
   WINDOW *wnd;
   LOC edpos={2,1};
   word edkey;

   LIFE_IO0.border.ttl = save ? stitle : ltitle;
   wnd = wnd_Open (&LIFE_IO0, &LIFE_IOH0, 0, 0);
   wnd_LinEd (wnd, &edpos, 40, DSP_WHITE, DSP_BLACK, 0, name, MAXPATH, &edkey);
   wnd_Close (wnd);

   return edkey == KBD_NORMAL(ESC) ? 0 : 1;

}/*askFileName*/

/**
*
*  Save -- 뢠 䨣  䠩
*
* 饭	result = Save();
*		int result	1, ᫨   浪,
*				0, ᫨  㤠  䠩.
*
* ᠭ	 , 訢  짮⥫  䠩.
*		⠥ ந஢ ⢥:
*		᫨ 砥 㯯 ᨬ, .. '*'  '?',
*		   ᮧ     䠩,
*		᫨   䠩,  '*'  ⠪
*		   ᮧ    䠩.
*		᫨ 䠩    㦥 , 
*		 ७    bak.
*
* 頥    result	1, ᫨   浪,
*			0, ᫨  㤠  䠩.
*
**/
ENTRY int Save (void)
{
   FILE *outF;
   static char name[MAXPATH]="*.pos";
   char sname[MAXPATH], normname [MAXPATH];
   int  res, choice;
   char _name[MAXPATH],*_n,*cur;

   strcpy(sname,name);
   OutStatistics("asking");
   if (!askFileName(sname,1)) {
      OutStatistics("");
      return 1;
   }

   OutStatistics("");
   strcpy(name,sname);

   strrev(name);
   for(choice=0,_n=_name,cur=name;*cur && !choice;) {
      *_n = *cur++;
      if(*_n++ == '.' &&
      		(choice=(*cur == '\\' || *cur == '/' || !*cur)) != 0)
        *_n++ = '*';
   }
   while((*_n++=*cur++)!=0);
   strrev(_name);
   strcpy(name,_name);
   if (strpbrk(name, "*?"))
      getFileName(name,sname);
   strcpy(name,sname);

   utl_fname (name, normname, &res);
   makeBak (name);

   if ((outF = fopen (name, "wt")) == NULL)
      return 0;

   OutStatistics("writing");
   saveToFile(outF);
   OutStatistics("");

   return 1;

}/*Save*/

/**
*
*  Load -- ⠥ 䨣  䠨
*
* 饭	res = Load();
*
*               int res         0, ᫨ 䠩  㤠 
*					(  稭),
*                               1, ᫨  䠩   浪,
*			       -1, ᫨  ⢥    䠩
*                                       짮⥫  ESC.
*
* ᠭ	 , 訢  짮⥫  䠩.
*		⠥ ந஢ ⢥:
*		᫨ 砥 㯯 ᨬ, .. '*'  '?',
*		   ᮧ     䠩,
*		᫨   䠩,  '*'  ⠪
*		   ᮧ    䠩.
*
* 頥    res         0, ᫨ 䠩  㤠 
*                                       (  稭),
*                           1, ᫨  䠩   浪,
*                          -1, ᫨  ⢥    䠩
*                                       짮⥫  ESC.
*
**/
ENTRY int Load (void)
{
   static char name[MAXPATH]="*.pos";
   char lname[MAXPATH], normname [MAXPATH];
   int res, choice;
   char _name[MAXPATH],*_n,*cur;


   strcpy(lname,name);
   OutStatistics("asking");
   if (!askFileName(lname,0)) {
      OutStatistics("");
      return -1;
   }

   OutStatistics("");
   strcpy(name,lname);

   strrev(name);
   for(choice=0,_n=_name,cur=name;*cur && !choice;) {
      *_n = *cur++;
      if(*_n++ == '.' &&
      		(choice=(*cur == '\\' || *cur == '/' || !*cur)) != 0)
        *_n++ = '*';
   }
   while((*_n++=*cur++)!=0);
   strrev(_name);
   strcpy(name,_name);
   if (strpbrk(name, "*?"))
      getFileName(name,lname);
   else
      strcpy(lname,name);

   utl_fname (lname, normname, &res);
   OutStatistics("reading");
   if (!readFile(lname))
      return 0;

   stepNo = 0;
   OutStatistics("");
   return 1;
}/*Load*/

/**
*
*  makeBak --    䠩
*
* 饭	makeBak(name);
*
*		char *name	 室 䠩
*
* ᠭ	२뢠 䠩     䠩 
*		⥬    ७ ".bak".
*
* NB		 㤠  ᮮ頥!!!
*
* 頥	void	.. 祣.
*
**/
LOCAL void makeBak (char *name)
{
   char normname [MAXPATH], dr [MAXDRIVE], dir [MAXDIR],
            fname [MAXFILE], ext [MAXEXT], bakname [MAXPATH];
   int res;

   OutStatistics("making bat");
   utl_fname (name, normname, &res);

   if(FileExists(normname)) {
      fnsplit (normname, dr, dir, fname, ext);
      fnmerge (bakname, dr, dir, fname, ".bak");
      if(FileExists(bakname))
        remove(bakname);
      rename (normname, bakname);
   }
   strcpy(name,normname);
   OutStatistics("");
}/*makeBak*/

/**
*
*  saveToFile -- 뢠 䨣  䠩
*
* 饭	saveToFile(file);
*
*		FILE *file	(!) 䠩   
*				 ᠭ .
*
* ᠭ	  뢠 窨  䠩.
*
* 頥	void	.. 祣.
*
**/
LOCAL void saveToFile (FILE *outF)
{
   CELL *c;

   for (c = mainList; c; c = c->next)
      fprintf (outF, "%ld %ld\n", c->loc.x, c->loc.y);

   fclose (outF);

}/*saveToFile*/

/**
*
*  finMessage -- 뢥 ᮮ饭  "뢠"
*
* 饭	finMessage(fmt,arg1,...);
*
* ᠭ   	㭪 뢮 㬥  ᮮ⢥⢨  
*		ଠ⮬  ⠭ 뢮, ᫥ 祣 믮
*		ணࠬ ⠭    -1.
*
* 頥	void,   祣.
*
**/

ENTRY void finMessage(char *fmt,...)
{
   va_list argptr;

   va_start(argptr,fmt);

   vprintf(fmt,argptr);
   exit(-1);
}/*finMessage*/

