/**
*  , ⢫騩 室  .
*	 ࠡ 室   ।⢠.
*
* 	3.5	(C)Copyright InfoScope Inc. 1991
*
**/


#include <mn_core.h>
#include <mn_find.h>
#include <kbdcodes.h>

/**
*
*    mn_traverseLineStyle  -- 室  "⮬" 
*
* 饭 pitem = mn_traverseGridStyle(pset, key);
*
* ࠬ: MN_ITEM_PTR pitem	       㭪 
*				     NULL, ᫨ key  㤠
*				     ஢
*            MN_ITEM_SET *set          㭪⮢
*            unsigned    key           
*
* ᠭ   	㭪 ⠥ ஢   ⮩
*	 	 , ᫨   㤠, । ।
*		⨢ 㭪, 䨪 ண  頥.
*		 ⨢ 砥 㭪 頥 0.
*
*     NB	 ࠡ 㭪樨 ।,  0   
*		䨪஬ 㭪!
*
* 頥	ident	     䨪  㭪
*			      0, ᫨ key  㤠 ஢.
*
* 뢠 ᫥騥 㭪樨 ⥬:
*    KBD_...(), mn_navFind...(),
*
* 	3.5	(C)Copyright InfoScope Inc. 1991
*
**/
ENTRY MN_ITEM_PTR mn_traverseLineStyle(MN_ITEM_SET *pset, unsigned key)
{
   MN_ITEM_PTR	pitem=NULL;
   LOC		*ploc=&mn_ItemLoc(mn_CurrentInSet(pset));

   switch(key) {
       case KBD_NORMAL(UP) :
          pitem = mn_navFindAbove(pset,ploc);
          if(pitem == NULL)
              pitem = mn_navFindLowest(pset,ploc);
          break;
       case KBD_NORMAL(DOWN) :
          pitem = mn_navFindUnder(pset,ploc);
          if(pitem == NULL)
              pitem = mn_navFindHighest(pset,ploc);
          break;
       case KBD_NORMAL(LEFT) :
          pitem = mn_navFindLeft(pset,ploc);
          if(pitem == NULL)
              pitem = mn_navFindRightest(pset,ploc);
          break;
       case KBD_NORMAL(RIGHT) :
          pitem = mn_navFindRight(pset,ploc);
          if(pitem == NULL)
              pitem = mn_navFindLeftest(pset,ploc);
          break;
       case KBD_NORMAL(HOME) :
          pitem = mn_FirstInSet(pset);
          break;
       case KBD_NORMAL(END) :
          pitem = mn_GetLastItem(pset);
          break;
   }/*switch*/

   return pitem;

}/*mn_traverseLineStyle*/

/**
*
*    mn_traverseGridStyle  -- 室    ⨫ Grid
*
* 饭 pitem = mn_traverseGridStyle(pset, key);
*
* ࠬ: MN_ITEM_PTR pitem	       㭪
*				      NULL, ᫨ key  㤠
*				     ஢
*            MN_ITEM_SET *set          㭪⮢
*            unsigned    key           
*
* ᠭ   	㭪 ⠥ ஢   ⮩
*	 	 , ᫨   㤠, । ।
*		⨢ 㭪, 䨪 ண  頥.
*		 ⨢ 砥 㭪 頥 0.
*
*     NB	 ࠡ 㭪樨 ।,  0   
*		䨪஬ 㭪.
*
* 頥	ident	     䨪  㭪
*				      0, ᫨ key  㤠
*				     ஢.
*
* 뢠 ᫥騥 㭪樨 ⥬:
*    mn_navPopKey(), KBD_...(), mn_navFind...(),
*
* 	3.5	(C)Copyright InfoScope Inc. 1991
*
**/
ENTRY MN_ITEM_PTR mn_traverseGridStyle(MN_ITEM_SET *pset, unsigned key)
{
   MN_ITEM_PTR	pitem=NULL;
   LOC		*ploc=&mn_ItemLoc(mn_CurrentInSet(pset));

   switch(key) {
       case KBD_NORMAL(UP) :
          pitem = mn_navFindAbove(pset,ploc);
          break;
       case KBD_NORMAL(DOWN) :
          pitem = mn_navFindUnder(pset,ploc);
          break;
       case KBD_NORMAL(LEFT) :
          pitem = mn_navFindLeft(pset,ploc);
          if(pitem == NULL)
              pitem = mn_GetPrevItemPtr(pset,mn_CurrentInSet(pset));
          break;
       case KBD_NORMAL(RIGHT) :
          pitem = mn_navFindRight(pset,ploc);
          if(pitem == NULL)
              pitem = mn_GetNextItemPtr(mn_CurrentInSet(pset));
          break;
       case KBD_NORMAL(HOME) :
          pitem = mn_FirstInSet(pset);
          break;
       case KBD_NORMAL(END) :
          pitem = mn_GetLastItem(pset);
          break;
   }/*switch*/

   return pitem;

}/*mn_traverseGridStyle*/

