
            {-------------------------------------------------}
            {         ணࠬ EditFont V 1.0                }
            {-------------------------------------------------}
            {  ணࠬ஢ : Turbo Pascal V 6.0      }
            {-------------------------------------------------}
            {  ᮧ : 08/04/1992                      }
            {  ᫥  : 09/04/1992           }
            {-------------------------------------------------}
            {   ணࠬ ।祭  ।஢    }
            {            䠩  ⮢              }
            {-------------------------------------------------}
            {  (c) 1992 ᫠                          }
            {-------------------------------------------------}

PROGRAM Edit_Font;

USES Dos, Crt, Def, FKey11;

VAR
   Fl : FILE; {  ᬠਢ  ।㥬  }

   SizeFont : LONGINT;
              {  ।㥬 䠩 ⮢ }

   Counter : LONGINT;
              { ⥫   ࢮ ᬠਢ  }

   ScreenBuf : ARRAY [ 1..256 ] OF BYTE;
              {  ࠭ }

   SingWrite : BOOLEAN;
              { ਧ  ⥪饣  }

   BlockBegin : LONGINT;
              { થ 砫  }

   BlockEnd : LONGINT;
              { થ   }

   KeyExit : BOOLEAN;
              { ਧ 室 }

   NameFont : STRING [ 40 ];
               {  䠩  }

   SizeYFont : BYTE;
               { ⢮ ப  ᨬ  }

   SizeXFont : BYTE;
               { ⢮ ᥫ  ਧ⠫ }

   Orient : BYTE;
               { ਥ ⮡ࠦ  }

   MaxScreen : BYTE; { ⢮  ⮡ࠦ  ࠭ }

   CurrentByte : BYTE; { 騩   ࠭ }

   CurrentBit : BYTE;  { 騩   ࠭ }

   StartAddres : LONGINT; { ⮢  }

{----------------------------------------------------------}

PROCEDURE War ( Mess : STRING );

          { 뤠 ।०饣 ᮮ饭 }
VAR
   Index : WORD;

BEGIN
     TEXTBACKGROUND ( BLACK );
     TEXTCOLOR ( LIGHTRED + BLINK );
     GOTOXY ( 1, 22 );
     WRITE ( Mess );
     FOR Index := 10 DOWNTO 1 DO
         BEGIN
              SOUND ( 15 * Index );
              DELAY ( 200 );
              NOSOUND;
              DELAY ( 100 )
         END;
     DELAY ( 2000 );
     GOTOXY ( 1, 22 );
     WRITE ( '                                                         ' )

END; { procedure Mess }

{----------------------------------------------------------}

FUNCTION HexStr ( Num : LONGINT ) : STRING;

         { ८ࠧ 楫 ᫠  ᭠ ଠ }
VAR
   Line : STRING;
   Hlp : LONGINT;
   Index : LONGINT;

BEGIN
     IF ( Num < 0 ) THEN
        BEGIN
             HexStr := '';
             EXIT
        END;
      Line := '';
      REPEAT
            Index := Num MOD 16;
            CASE Index OF
                   0 : Line := '0' + Line;
                   1 : Line := '1' + Line;
                   2 : Line := '2' + Line;
                   3 : Line := '3' + Line;
                   4 : Line := '4' + Line;
                   5 : Line := '5' + Line;
                   6 : Line := '6' + Line;
                   7 : Line := '7' + Line;
                   8 : Line := '8' + Line;
                   9 : Line := '9' + Line;
                   10: Line := 'A' + Line;
                   11: Line := 'B' + Line;
                   12: Line := 'C' + Line;
                   13: Line := 'D' + Line;
                   14: Line := 'E' + Line;
                   15: Line := 'F' + Line
            ELSE
                War ( '訡 ८ࠧ' )
            END;
            Num := Num DIV 16
      UNTIL ( Num <= 0 );
      HexStr := Line

END; { function HexStr }

{----------------------------------------------------------}

PROCEDURE ShowFont_Vert;

          {   ࠭ ⥪騩 १ 䠩  }
          {            ⨪쭮 ਥ樨             }
VAR
   Index, Hlp : BYTE;
   Sing : BOOLEAN;
   SB : BYTE;
   Ch : CHAR;
   DealSymbol : BYTE;
   FirstNumber : LONGINT;
   HelpS : STRING [ 80 ];

BEGIN
     FOR Index := 1 TO MaxScreen DO
         BEGIN
              SB := 1;
              IF ( ( ( Counter + Index - 1 ) >= BlockBegin ) AND
                   ( ( Counter + Index - 1 ) <= BlockEnd )
                     AND ( BlockEnd > 0  ) AND ( BlockBegin > 0 ) ) THEN
                 BEGIN
                      TEXTCOLOR ( BLACK );
                      TEXTBACKGROUND ( LIGHTGRAY )
                 END
              ELSE
                  BEGIN
                      TEXTCOLOR ( YELLOW );
                      TEXTBACKGROUND ( BLUE )
                  END;
              FOR Hlp := 1 TO 8 DO
                  BEGIN
                       IF ( ( ScreenBuf [ Index ] AND SB ) <> 0 ) THEN
                          Ch := #04
                       ELSE
                           Ch := ' ';
                       IF ( Hlp <> 8 ) THEN
                          SB := SB * 2;
                       GOTOXY ( Index, Hlp );
                       WRITE ( Ch )
                  END;
         END;

     TEXTBACKGROUND ( BLACK );
     FirstNumber := ( Counter - StartAddres ) DIV SizeYFont;
     DealSymbol := MaxScreen DIV SizeYFont;
     FOR Index := 1 TO DealSymbol DO
         BEGIN
              GOTOXY ( ( ( Index - 1 ) * SizeYFont + 1 ),10 );
              STR ( FirstNumber, HelpS );
              HelpS := '<' + HelpS;
              WHILE ( LENGTH ( HelpS ) < SizeYFont ) DO
                    HelpS := HelpS + ' ';
              TEXTCOLOR ( GREEN );
              WRITE ( HelpS );

              HelpS := HexStr ( FirstNumber );
              IF ( LENGTH ( HelpS ) = 1 ) THEN
                  HelpS := '0' + HelpS;
              GOTOXY ( ( ( Index - 1 ) * SizeYFont + 1 ),11 );
              HelpS := '|' + HelpS;
              WHILE ( LENGTH ( HelpS ) < SizeYFont ) DO
                    HelpS := HelpS + ' ';
              TEXTCOLOR ( RED );
              WRITE ( HelpS );
              INC ( FirstNumber )
         END;

END; { procedure ShowFont_Vert }

{----------------------------------------------------------}

PROCEDURE ShowFont_Hor;

          {   ࠭ ⥪騩 १ 䠩  }
          {          ਧ⠫쭮 ਥ樨             }
VAR
   Index, Hlp : BYTE;
   Sing : BOOLEAN;
   SB : BYTE;
   Ch : CHAR;
   DealSymbol : BYTE;
   FirstNumber : LONGINT;
   HelpS : STRING [ 80 ];

BEGIN
     FOR Index := 1 TO MaxScreen DO
         BEGIN
              SB := 1;
              IF ( ( ( Counter + Index - 1 ) >= BlockBegin ) AND
                   ( ( Counter + Index - 1 ) <= BlockEnd )
                      AND ( BlockEnd > 0 ) AND ( BlockBegin > 0 ) ) THEN
                 BEGIN
                      TEXTCOLOR ( BLACK );
                      TEXTBACKGROUND ( LIGHTGRAY )
                 END
              ELSE
                  BEGIN
                      TEXTCOLOR ( YELLOW );
                      TEXTBACKGROUND ( BLUE )
                  END;
              FOR Hlp := 8 DOWNTO 1 DO
                  BEGIN
                       IF ( ( ScreenBuf [ Index ] AND SB ) <> 0 ) THEN
                          Ch := #04
                       ELSE
                           Ch := ' ';
                       IF ( Hlp <> 1 ) THEN
                          SB := SB * 2;
                       GOTOXY ( Index, Hlp );
                       WRITE ( Ch )
                  END;
         END;

     TEXTBACKGROUND ( BLACK );
     FirstNumber := ( Counter - StartAddres ) DIV SizeYFont;
     DealSymbol := MaxScreen DIV SizeYFont;
     FOR Index := 1 TO DealSymbol DO
         BEGIN
              GOTOXY ( ( ( Index - 1 ) * SizeYFont + 1 ),10 );
              STR ( FirstNumber, HelpS );
              HelpS := '<' + HelpS;
              WHILE ( LENGTH ( HelpS ) < SizeYFont ) DO
                    HelpS := HelpS + ' ';
              TEXTCOLOR ( GREEN );
              WRITE ( HelpS );

              HelpS := HexStr ( FirstNumber );
              IF ( LENGTH ( HelpS ) = 1 ) THEN
                  HelpS := '0' + HelpS;
              GOTOXY ( ( ( Index - 1 ) * SizeYFont + 1 ),11 );
              HelpS := '|' + HelpS;
              WHILE ( LENGTH ( HelpS ) < SizeYFont ) DO
                    HelpS := HelpS + ' ';
              TEXTCOLOR ( RED );
              WRITE ( HelpS );
              INC ( FirstNumber )
         END;

END; { procedure ShowFont_Hor }

{----------------------------------------------------------}

PROCEDURE SetCursor_Hor;

          { ⠭   ਧ⠫쭮 ਥ樨 }
BEGIN
     IF ( ( ( Counter + CurrentByte - 1 ) >= BlockBegin ) AND
          ( ( Counter + CurrentByte - 1 ) <= BlockEnd ) ) THEN
        BEGIN
             TEXTCOLOR ( BLACK );
             TEXTBACKGROUND ( LIGHTGRAY )
        END
     ELSE
         BEGIN
              TEXTCOLOR ( YELLOW );
              TEXTBACKGROUND ( BLUE )
         END;
     GOTOXY ( CurrentByte, ( 9 - CurrentBit ) )

END; { procedure SetCursor_Hor }

{----------------------------------------------------------}

PROCEDURE SetCursor_Vert;

           { ⠭   ⨪쭮 ਥ樨 }
BEGIN
     IF ( ( ( Counter + CurrentByte - 1 ) >= BlockBegin ) AND
          ( ( Counter + CurrentByte - 1 ) <= BlockEnd )
            AND ( BlockEnd > 0 ) AND ( BlockBegin > 0 ) ) THEN
        BEGIN
             TEXTCOLOR ( BLACK );
             TEXTBACKGROUND ( LIGHTGRAY )
        END
     ELSE
         BEGIN
              TEXTCOLOR ( YELLOW );
              TEXTBACKGROUND ( BLUE )
         END;
     GOTOXY ( CurrentByte, ( CurrentBit ) )

END; { procedure SetCursor_Vert }

{----------------------------------------------------------}

PROCEDURE SetCursor;

BEGIN
     TEXTBACKGROUND ( BLACK );
     TEXTCOLOR ( LIGHTRED );
     GOTOXY ( 30, 24 );
     WRITE ( '  -',Counter + CurrentByte, '         ' );
     GOTOXY ( 60, 24 );
     WRITE ( '  -',CurrentBit - 1, ' ' );

     CASE Orient OF
            1 : SetCursor_Hor;
            2 : SetCursor_Vert
     ELSE
         BEGIN
              WRITELN ( '⨬ ਥ' );
              WRITELN ( #7 );
              HALT ( 1 )
         END
     END

END; { Procedure SetCursor }

{----------------------------------------------------------}

PROCEDURE ShowFont;

          {   ࠭ ⥪騩 १ 䠩  }
          {          ⠭ ਥ樨              }
BEGIN
     CASE Orient OF
            1 : ShowFont_Hor;
            2 : ShowFont_Vert
     ELSE
         BEGIN
              WRITELN ( '⨬ ਥ' );
              WRITELN ( #7 );
              HALT ( 1 )
         END
     END;

     TEXTBACKGROUND ( BLACK );
     TEXTCOLOR ( LIGHTGRAY );
     GOTOXY ( 1, 24 );
     WRITE ( '  - /',Counter, '           ' );

     SetCursor

END; { procedure ShowFont }

{----------------------------------------------------------}

FUNCTION GetCommand : CHAR;

         {  ⥪  । }
BEGIN
     GetCommand := GetKey;
     IF ( SingKey ) THEN
        GetCommand := GetKey

END; { Function GetCommand }

{----------------------------------------------------------}

PROCEDURE SetUp;

          { 砫 ⠭ }
VAR
   Index : BYTE;
   Err : INTEGER;
   HelpS : STRING [ 20 ];
   DealSymbol : BYTE;

BEGIN
     KeyExit := FALSE;
     SingWrite := FALSE;
     HideKey;
     Orient := 1;
     MaxScreen := 80;
     CurrentByte := 1;
     CurrentBit := 1;
     Counter := 0;
     SizeXFont := 1;
     SizeYFont := 8;
     CurrentByte := 1;
     CurrentBit := 1;
     BlockBegin := - 1;
     BlockEnd := - 1;

     FOR Index := 2 TO 5 DO
         BEGIN
              IF ( ( POS ( '/X',( PARAMSTR ( Index ) ) ) <> 0 ) OR
                 ( POS ( '/x', ( PARAMSTR ( Index ) ) ) <> 0 ) ) THEN
                 BEGIN
                      HelpS := PARAMSTR ( Index );
                      DELETE ( HelpS, 1, 2 );
                      VAL ( HelpS, SizeXFont, Err );
                      IF ( ( Err <> 0 ) OR  ( SizeXFont = 0 ) OR
                           ( SizeXFont > 3 ) ) THEN
                          BEGIN
                               WRITELN ( '⨬ 祭 - /X1..3' );
                               WRITELN ( #7 );
                               HALT ( 1 )
                          END
                 END;
              IF ( ( POS ( '/Y', ( PARAMSTR ( Index ) ) ) <> 0 ) OR
                 ( POS ( '/y', ( PARAMSTR ( Index ) ) ) <> 0 ) ) THEN
                 BEGIN
                      HelpS := PARAMSTR ( Index );
                      DELETE ( HelpS, 1, 2 );
                      VAL ( HelpS, SizeYFont, Err );
                      IF ( ( Err <> 0 ) OR  ( SizeYFont < 4 ) OR
                           ( SizeYFont > 80 ) ) THEN
                          BEGIN
                               WRITELN ( '⨬ 祭 - /Y4..80' );
                               WRITELN ( #7 );
                               HALT ( 1 )
                          END
                 END;
              IF ( ( POS ( '/O', ( PARAMSTR ( Index ) ) ) <> 0 ) OR
                 ( POS ( '/o', ( PARAMSTR ( Index ) ) ) <> 0 ) ) THEN
                 BEGIN
                      HelpS := PARAMSTR ( Index );
                      DELETE ( HelpS, 1, 2 );
                      VAL ( HelpS, Orient, Err );
                      IF ( ( Err <> 0 ) OR  ( Orient < 1 ) OR
                           ( Orient > 2 ) ) THEN
                          BEGIN
                               WRITELN ( '⨬ 祭 - /Y0..24' );
                               WRITELN ( #7 );
                               HALT ( 1 )
                          END
                 END;
              IF ( ( POS ( '/C', ( PARAMSTR ( Index ) ) ) <> 0 ) OR
                 ( POS ( '/c', ( PARAMSTR ( Index ) ) ) <> 0 ) ) THEN
                 BEGIN
                      HelpS := PARAMSTR ( Index );
                      DELETE ( HelpS, 1, 2 );
                      VAL ( HelpS, Counter, Err );
                      IF ( Err <> 0 ) THEN
                          BEGIN
                               WRITELN ( '⨬ 祭 - /C0..FILESIZE' );
                               WRITELN ( #7 );
                               HALT ( 1 )
                          END
                 END;
         END;

     StartAddres := Counter;
     CASE Orient OF
            1: BEGIN
                    DealSymbol := 80 DIV SizeYFont;
                    MaxScreen := DealSymbol * SizeYFont
               END;

            2: BEGIN
                    DealSymbol := 80 DIV SizeYFont;
                    MaxScreen := DealSymbol * SizeYFont
               END
     ELSE
         BEGIN
              WRITELN ( '⨬ ਥ' );
              WRITELN ( #7 );
              HALT ( 1 )
         END
     END

END; { Procedure SetUp }

{----------------------------------------------------------}

PROCEDURE StartHelp;

BEGIN
     WRITELN ( ' ⮢ V 1.0, (c) 1992 ᫠ , FREEWARE' );
     WRITELN ( '' );
     WRITELN ( 'ଠ  ப :' );
     WRITELN ( 'EDFONTS.EXE <filename> [/O. /Y.. /C...]' );
     WRITELN ( '<filename> -  䠩 ᮤঠ饣 ' );
     WRITELN ( '/Ynn - ⢮ ᥫ  Y  4  80' );
     WRITELN ( '/On - 1  2   ਥ' );
     WRITELN ( '        ࠭ /   /' );
     WRITELN ( '/nnnnnn - ⮢  砫 ᬮ' );
     WRITELN ( '       䠩 0 ..   / 筮 ' );
     WRITELN ( '      ।⠢ /' );
     WRITELN ( '/H - ᪠' );
     WRITELN ( '' );
     WRITELN ( '   ।஢ ⮢ ' );
     WRITELN ( '६饭    㭪樮쭮' );
     WRITELN ( '  誨. 㯭 ⠪ ' );
     WRITELN ( '樨,  ஢ ,  ' );
     WRITELN ( '   ⥭   ᪠' );
     WRITELN ( '     ९訢 ஢' );
     WRITELN ( 'ਭ஢ ࠧ ப' );
     WRITELN ( '.   ⥫. 441-40-81 (  )' )

END; { Procedure StartHelp }

{----------------------------------------------------------}

PROCEDURE SetFont;

          { ⠭   }
BEGIN
     IF ( ( PARAMSTR ( 1 ) = '' ) OR ( PARAMSTR ( 1 ) = '/H' ) OR
        ( PARAMSTR ( 1 ) = '/h' ) ) THEN
        BEGIN
             StartHelp;
             HALT ( 1 )
        END;
     NameFont := PARAMSTR ( 1 );
     ASSIGN ( Fl, NameFont );
     RESET ( Fl, 1 );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             WRITELN;
             WRITELN ( '訡  䠩 ' );
             HALT ( 1 )
        END;

     SizeFont := FILESIZE ( Fl )

END; { procedure SetFont }

{----------------------------------------------------------}

PROCEDURE ReadBuffer;

          { ⥭   }
BEGIN
     SEEK ( Fl, Counter );
     BLOCKREAD ( Fl, ScreenBuf, MaxScreen );
     IF ( IORESULT <> 0 ) THEN
        War ( '訡 ⥭ 䠩' )

END; { procedure ReadBuffer }

{----------------------------------------------------------}

PROCEDURE WriteBuffer;

          {    }
BEGIN
     IF ( SingWrite ) THEN
        BEGIN
             SEEK ( Fl, Counter );
             BLOCKWRITE ( Fl, ScreenBuf, MaxScreen );
             IF ( IORESULT <> 0 ) THEN
                 War ( '訡  ' );
             SingWrite := FALSE
        END

END; { procedure WriteBuffer }

{----------------------------------------------------------}

PROCEDURE SetScreen;

          { ⠭ ࠭ }
BEGIN
     WINDOW ( 1, 1, 80, 25 );
     TEXTBACKGROUND ( BLACK );
     CLRSCR;
     TEXTCOLOR ( LIGHTCYAN );
     GOTOXY ( 1, 14 );
     WRITELN ( '     '+ #27 + ' , ' + #26 +' , ' + #24 + ' , ' + #25 +
               ' / mouse /  - ६饭 㪠⥫  । ࠭' );
     WRITELN ( '     Ctrl+ '+ #27 + ' ,Ctrl+ ' + #26 +
               ' -  ࠭    ' );
     WRITELN ( '     Enter / .  mouse /- ஢ ᥫ' );
     WRITELN ( '     ESC - 室   ' );
     WRITELN ( '     Ctrl-KB - ⬥⪠ 砫 , Ctrl-KK -  ' );
     WRITELN ( '     Ctrl-KH - ⬥ , Ctrl-KC - ஢ ' );
     WRITELN ( '     Ctrl-KW -  , Ctrl-KR - ⥭ ' );
     TEXTCOLOR ( MAGENTA );
     GOTOXY ( 1, 25 );
     WRITE ( '     ⮢  V 1.0       (c) 1992 ᫠ ' )

END; { procedure SetScreen }

{----------------------------------------------------------}

PROCEDURE ChangeInf;

VAR
   Key : BOOLEAN;
   Mask : BYTE;

BEGIN
     SingWrite := TRUE;
     CASE CurrentBit OF
             1 : Mask := $01;
             2 : Mask := $02;
             3 : Mask := $04;
             4 : Mask := $08;
             5 : Mask := $10;
             6 : Mask := $20;
             7 : Mask := $40;
             8 : Mask := $80
     END;
     IF ( ( ScreenBuf [ CurrentByte ] AND Mask ) <> 0 ) THEN
        BEGIN
             WRITE ( ' ' );
             ScreenBuf [ CurrentByte ] := ScreenBuf [ CurrentByte ]
                                          AND ( NOT Mask )
        END
     ELSE
         BEGIN
              WRITE ( #04 );
             ScreenBuf [ CurrentByte ] := ScreenBuf [ CurrentByte ]
                                          OR Mask
         END;
     SetCursor

END; { PROCEDURE ChangeInf }

{----------------------------------------------------------}

PROCEDURE BitLeft;

          {    }
BEGIN
     CASE Orient OF
            1 : BEGIN
                     DEC ( CurrentBit );
                     IF ( CurrentBit < 1 ) THEN
                        CurrentBit := 1
                END;
            2 : BEGIN
                     INC ( CurrentBit );
                     IF ( CurrentBit > 8 ) THEN
                        CurrentBit := 8
                END
     END;
     SetCursor

END; { procedure BitLeft }

{----------------------------------------------------------}

PROCEDURE BitRight;

          {   ghf }
BEGIN
     CASE Orient OF
            1 : BEGIN
                     INC ( CurrentBit );
                     IF ( CurrentBit > 8 ) THEN
                        CurrentBit := 8
                END;
            2 : BEGIN
                     DEC ( CurrentBit );
                     IF ( CurrentBit < 1 ) THEN
                        CurrentBit := 1
                END
     END;
     SetCursor

END; { procedure BitRight }

{----------------------------------------------------------}

PROCEDURE ByteLeft;

          {    }
BEGIN
     CASE Orient OF
            1 : BEGIN
                     DEC ( CurrentByte );
                     IF ( CurrentByte < 1 ) THEN
                        CurrentByte := 1
                END;
            2 : BEGIN
                     DEC ( CurrentByte );
                     IF ( CurrentByte < 1 ) THEN
                        CurrentByte := 1
                END
     END;
     SetCursor

END; { procedure ByteLeft }

{----------------------------------------------------------}

PROCEDURE ByteRight;

          {   ࠢ }
BEGIN
     CASE Orient OF
            1 : BEGIN
                     INC ( CurrentByte );
                     IF ( CurrentByte > MaxScreen ) THEN
                        CurrentByte := MaxScreen
                END;
            2 : BEGIN
                     INC ( CurrentByte );
                     IF ( CurrentByte > MaxScreen ) THEN
                        CurrentByte := MaxScreen
                END
     END;
     SetCursor

END; { procedure ByteRight }

{----------------------------------------------------------}

PROCEDURE SymbolLeft;

          {  ᨬ  }
BEGIN
     IF ( Counter <= StartAddres ) THEN
        EXIT;
     WriteBuffer;
     Counter := Counter - SizeYFont * SizeXFont;
     IF ( Counter < StartAddres ) THEN
        Counter := StartAddres;
     ReadBuffer;
     ShowFont

END; { PROCEDURE SymbolLeft }

{----------------------------------------------------------}

PROCEDURE SymbolRight;

          {  ᨬ ࠢ }
BEGIN
     IF ( ( Counter + SizeXFont * SizeYFont ) >= SizeFont ) THEN
        EXIT;
     WriteBuffer;
     Counter := Counter + SizeYFont * SizeXFont;
     IF ( ( Counter + SizeXFont * SizeYFont ) > SizeFont ) THEN
        Counter := SizeFont - SizeYFont * SizeXFont;
     ReadBuffer;
     ShowFont

END; { PROCEDURE SymbolRight }

{----------------------------------------------------------}

PROCEDURE Init;

          { 樠 䠩   ६ ।஢ }
BEGIN
     SetUp;
     SetFont;
     ReadBuffer;
     SetScreen

END; { procedure Init }

{----------------------------------------------------------}

PROCEDURE SetBegin;

          { ⠭ થ 砫  }
BEGIN
     BlockBegin := Counter + CurrentByte - 1

END; { PROCEDURE SetBegin }

{----------------------------------------------------------}

PROCEDURE SetEnd;

          { ⠭ થ   }
BEGIN
     BlockEnd := Counter + CurrentByte - 1

END; { PROCEDURE SetEnd }

{----------------------------------------------------------}

PROCEDURE HideBlock;

          {   }
BEGIN
     BlockBegin := -1;
     BlockEnd := -1

END; { PROCEDURE HideBlock }

{----------------------------------------------------------}

PROCEDURE CopyBlock;

         { ஢  }
VAR
   Buf : POINTER;
   Size : LONGINT;

BEGIN
     IF ( ( BlockBegin > BlockEnd ) OR ( BlockBegin < 0 )
          OR ( BlockEnd < 0 ) ) THEN
        BEGIN
             SOUND ( 1000 );
             DELAY ( 100 );
             NOSOUND;
             EXIT
        END;
      GETMEM ( Buf, BlockEnd - BlockBegin + 1 );
      WriteBuffer;
      SEEK ( Fl, BlockBegin );
      BLOCKREAD ( Fl, Buf^, BlockEnd - BlockBegin + 1 );
      IF ( IORESULT <> 0 ) THEN
         War ( '訡 ⥭    䠩' );
      SEEK ( Fl, Counter + CurrentByte - 1 );
      BLOCKWRITE ( Fl, Buf^, BlockEnd - BlockBegin + 1 );
      IF ( IORESULT <> 0 ) THEN
         War ( '訡    䠩' );
      FREEMEM ( Buf, BlockEnd - BlockBegin + 1 );
      ReadBuffer;
      Size := BlockEnd - BlockBegin;
      BlockBegin := Counter + CurrentByte - 1;
      BlockEnd := BlockBegin + Size

END; { PROCEDURE Block }

{----------------------------------------------------------}

FUNCTION GetFileName : STRING;

         {   䠩 }
VAR
   Line : STRING;

BEGIN
     TEXTBACKGROUND ( BLACK );
     TEXTCOLOR ( WHITE );
     GOTOXY ( 30, 23 );
     WRITE ( '  䠩 >' );
     READLN ( Line );
     GOTOXY ( 1, 23 );
     WRITE ( '                                                         ' );
     GetFileName := Line

END;  { FUNCTION GetFileName }

{----------------------------------------------------------}

PROCEDURE WriteBlock;

          {   }
VAR
   Ft : FILE;
   Name : STRING;
   Buf : POINTER;

BEGIN
     IF ( ( BlockBegin > BlockEnd ) OR ( BlockBegin < 0 )
          OR ( BlockEnd < 0 ) ) THEN
        BEGIN
             SOUND ( 1000 );
             DELAY ( 100 );
             NOSOUND;
             EXIT
        END;

     TEXTBACKGROUND ( BLACK );
     TEXTCOLOR ( LIGHTGREEN );
     GOTOXY ( 1, 23 );
     WRITE ( ' ' );
     Name := GetFileName;
     ASSIGN ( Ft, Name );
     REWRITE ( Ft, 1 );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             War ( '訡 ᮧ 䠩' );
             EXIT
        END;
      GETMEM ( Buf, BlockEnd - BlockBegin + 1 );
      SEEK ( Fl, BlockBegin );
      BLOCKREAD ( Fl, Buf^, BlockEnd - BlockBegin + 1 );
      IF ( IORESULT <> 0 ) THEN
         War ( '訡 ⥭ ' );
      BLOCKWRITE ( Ft, Buf^, BlockEnd - BlockBegin + 1 );
      IF ( IORESULT <> 0 ) THEN
         War ( '訡    䠩' );
      FREEMEM ( Buf, BlockEnd - BlockBegin + 1 );
      CLOSE ( Ft );
      IF ( IORESULT <> 0 ) THEN
         War ( '訡  ᮧ 䠩' )

END; { PROCEDURE WriteBlock }

{----------------------------------------------------------}

PROCEDURE ReadBlock;

          {   }
VAR
   Ft : FILE;
   Name : STRING;
   Buf : POINTER;

BEGIN
     WriteBuffer;
     TEXTBACKGROUND ( BLACK );
     TEXTCOLOR ( LIGHTGREEN );
     GOTOXY ( 1, 23 );
     WRITE ( '⥭ ' );
     Name := GetFileName;
     ASSIGN ( Ft, Name );
     RESET ( Ft, 1 );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             War ( ' ⠪ 䠩' );
             EXIT
        END;
      IF ( ( FILESIZE ( Ft ) < 1 ) OR
           ( FILESIZE ( Ft ) >= $FFFE ) ) THEN
         BEGIN
              War ( '訡 ଠ 䠩' );
              EXIT
         END;
      GETMEM ( Buf, FILESIZE ( Ft ) );
      BLOCKREAD ( Ft, Buf^, FILESIZE ( Ft ) );
      IF ( IORESULT <> 0 ) THEN
         War ( '訡 ⥭ 䠩' );
      SEEK ( Fl, Counter + CurrentByte - 1 );
      BLOCKWRITE ( Fl, Buf^, FILESIZE ( Ft ) );
      IF ( IORESULT <> 0 ) THEN
         War ( '訡    䠩' );
      BlockBegin := Counter + CurrentByte - 1;
      BlockEnd := BlockBegin + FILESIZE ( Ft ) - 1;
      FREEMEM ( Buf, FILESIZE ( Ft ) );
      CLOSE ( Ft );
      IF ( IORESULT <> 0 ) THEN
         War ( '訡  䠩' );
      ReadBuffer

END; { PROCEDURE ReadBlock }

{----------------------------------------------------------}

PROCEDURE BlockOperation;

          {  樨 }
VAR
   Index : WORD;

BEGIN
     CASE GetCommand OF

             #27             : EXIT;

             'B','b','','' : SetBegin;

             'K','k','','' : SetEnd;

             'H','h','','' : HideBlock;

             'C','c','','' : CopyBlock;

             'W','w','','' : WriteBlock;

             'R','r','','' : ReadBlock

     ELSE
         BEGIN
              FOR Index := 2000 DOWNTO 200 DO
                  BEGIN
                       SOUND ( Index );
                       IF ( ( Index MOD 4 ) = 0 ) THEN
                          DELAY ( 1 )
                  END;
              NOSOUND
         END
     END;
     ShowFont

END; { procedure BlockOperation }

{----------------------------------------------------------}

PROCEDURE EditFont;

          { ᬮ  ।஢ 䠩  }
BEGIN
     CASE GetCommand OF

          #11             : BlockOperation;

          #13             : ChangeInf;

          #27             : KeyExit := TRUE;

          Arrow_Down      : BitLeft;

          Arrow_Up        : BitRight;

          Arrow_Left      : ByteLeft;

          Arrow_Right     : ByteRight;

          Ctl_Arrow_Left  : SymbolLeft;

          Ctl_Arrow_Right : SymbolRight

     ELSE
         BEGIN
              SOUND ( 1000 );
              DELAY ( 100 );
              NOSOUND
         END
     END

END; { procedure EditFont }

{----------------------------------------------------------}

PROCEDURE Done;

          { ࠭ ।஢ 䠩  }
BEGIN
     WriteBuffer;
     CLOSE ( Fl );
     IF ( IORESULT <> 0 ) THEN
        War ( '訡  䠩' );
     TEXTCOLOR ( LIGHTGRAY );
     TEXTBACKGROUND ( BLACK );
     GOTOXY ( 1, 25 );
     WRITELN

END; { procedure Done }

{----------------------------------------------------------}

BEGIN
     Init;
     ShowFont;
     REPEAT
           EditFont
     UNTIL ( KeyExit );
     Done

END. { PROGRAM Edit_Pronter_Font }
