{$A+,B-,D+,E-,F-,G-,I-,L+,N-,O-,R+,S+,V+,X-}
{$M 16384,0,655360}

Unit VTest;

Interface

const
  IBMName  : array [0..5] of string[6] = ( '(none)', 'MDA', 'CGA', 'EGA', 'MCGA', 'VGA' );
  HercName : array [0..2] of string[7] = ( 'HGC', 'HGC+', 'InColor' );
  DisplayName : array [0..5] of string[34] = (
    '(none)',
    'MDA-compatible monochrome display',
    'CGA-compatible color display',
    'EGA-compatible color display',
    'PS/2-compatible monochrome display',
    'PS/2-compatible color display'
  );

type
  TVID = record
    TVideo0, TDisplay0 : Byte;
    TVideo1, TDisplay1 : Byte;
  end;

const
  MDA                 = 1;              { ⨯ ⥬ }
  CGA                 = 2;
  EGA                 = 3;
  MCGA                = 4;
  VGA                 = 5;
  HGC                 = $80;
  HGCPlus             = $81;
  InColor             = $82;

  MDADisplay          = 1;              { ⨯ ᯫ }
  CGADisplay          = 2;
  EGAColorDisplay     = 3;
  PS2MonoDisplay      = 4;
  PS2ColorDisplay     = 5;

var
  Video : TVID;

procedure TestVideo(var VData : TVID);

Implementation

procedure TestVideo(var VData : TVID); Assembler;
asm

        jmp     @Begin

@EGADisplays:   DB      CGADisplay      { 0000b, 0001b  (EGA switch values) }
                DB      EGAColorDisplay { 0010b, 0011b }
                DB      MDADisplay      { 0100b, 0101b }
                DB      CGADisplay      { 0110b, 0111b }
                DB      EGAColorDisplay { 1000b, 1001b }
                DB      MDADisplay      { 1010b, 1011b }

@DCCtable:      DB      0,0             { translate table for INT 10h func 1Ah }
                DB      MDA,MDADisplay
                DB      CGA,CGADisplay
                DB      0,0
                DB      EGA,EGAColorDisplay
                DB      EGA,MDADisplay
                DB      0,0
                DB      VGA,PS2MonoDisplay
                DB      VGA,PS2ColorDisplay
                DB      0,0
                DB      MCGA,EGAColorDisplay
                DB      MCGA,PS2MonoDisplay
                DB      MCGA,PS2ColorDisplay

@TestSequence:  DB      TRUE            {   ᯨ᮪ 䫠  ᮢ,     }
                DW      @FindPS2        {  । ࠤ,  ஬  }
                                        {  / ᬠਢ ࠧ   }
@EGAflag:       DB      0               {  ⥬ }
                DW      @FindEGA

@CGAflag:       DB      0
                DW      @FindCGA

@Monoflag:      DB      0
                DW      @FindMono

@NumberOfTests: DB      4

{
FindPS2

         ணࠬ ᯮ INT 10H 㭪 1Ah  ।  BIOS
         Display Combination Code (DCC)   饩 ⥬.
}
@FindPS2:

        mov     ax, 1A00h
        int     10h             { video BIOS info }

        cmp     al, 1Ah
        jne     @L1             { 室 ᫨ 㭪  ন,
                                   MCGA  VGA  ⥬ }

{     ८ࠧ BIOS DCCs   ⥬  ᯫ }

        mov     cx, bx
        xor     bh, bh          { BX := DCC  ⨢ ⥬ }

        or      ch, ch
        jz      @L2             { 室, ⮫쪮  ⥬  }

        mov     bl, ch          { BX := ⨢ DCC }
        add     bx, bx
        mov     ax, [bx+offset @DCCtable]

        mov     word ptr es:[di+TVID.TVideo1], ax

        mov     bl, cl
        xor     bh, bh          { BX := ⨢ DCC }

@L2:
        add     bx, bx
        mov     ax, [bx+offset @DCCtable]
        mov     word ptr es:[di+TVID.TVideo0], ax

    {  䫠  ⥬,   }

        mov     byte ptr [@CGAflag], FALSE
        mov     byte ptr [@EGAflag], FALSE
        mov     byte ptr [@Monoflag], FALSE

        lea     bx, es:[di+TVID.TVideo0]  { ᫨ BIOS ⨫ MDA ... }
        cmp     byte ptr [bx], MDA
        je      @L3
        lea     bx, es:[di+TVID.TVideo1]
        cmp     byte ptr [bx], MDA
        jne     @L1
@L3:
        mov     word ptr [bx], 0       { ... Hercules    ⠭ }
        mov     byte ptr @Monoflag, TRUE
@L1:
        retn

{
  FindEGA

  Look for an EGA.  This is done by making a call to an EGA BIOS function
   which doesn't exist in the default (MDA, CGA) BIOS.
}

@FindEGA:                       { 室  :  AH = flags            }
                                { 室 :  AH = flags            }
                                { TVideo0 &                      }
                                { TDisplay0 ࠡ⠭           }

        mov     bl, 10h         { BL := 10h (EGA info)   }
        mov     ah, 12h         { AH := INT 10H  㭪樨   }
        int     10h             { 맮 EGA BIOS                }
                                { ᫨ EGA BIOS ,   }
                                {  BL <> 10H                    }
                                {  CL = ⠭ ४⥫}
        cmp     bl,10h
        je      @L22            { 室 EGA BIOS   }

        mov     al, cl
        shr     al, 1           { AL := ४⥫/2         }
        mov     bx, offset @EGADisplays
        xlat                    { । ⨯ ᯫ  DIP      }
        mov     ah, al          { AH := ⨯ ᯫ }
        mov     al, EGA         { AL := ⨯ ⥬ }
        call    @FoundDevice

        cmp     ah, MDADisplay
        je      @L21            { 室, ᫨ EGA  ஬ ᯫ }

        mov     byte ptr @CGAflag, FALSE {  CGA, ᫨ EGA  梥⭮ ᯫ }
        jmp     @L22

@L21:
        mov     byte ptr @Monoflag, FALSE
                                 {  EGA   ,  MDA  }
                                 {  Hercules 㯭 }
@L22:
        retn

{
FindCGA

This is done by looking for the CGA's 6845 CRTC at I/O port 3D4H.
}

@FindCGA:                       { 室:      TVID ࠡ⠭ }

        mov     dx, 03D4h       { DX :=   CRTC }
        call    @Find6845
        jc      @L31            { 室, ᫨  }

        mov     al, CGA
        mov     ah, CGADisplay
        call    @FoundDevice

@L31:
        retn

{
 FindMono

 This is done by looking for the MDA's 6845 CRTC at I/O port 3B4H.  If
 a 6845 is found, the subroutine distinguishes between an MDA
 and a Hercules adapter by monitoring bit 7 of the CRT Status byte.
 This bit changes on Hercules adapters but does not change on an MDA.

 The various Hercules adapters are identified by bits 4 through 6 of
 the CRT Status value:

        000b = HGC
        001b = HGC+
        101b = InColor card
}

@FindMono:                      { 室 :      TVID ࠡ⠭ }
        mov     dx, 03B4h       { DX :=   CRTC }
        call    @Find6845
        jc      @L44            { 室, ᫨  }

        mov     dl, 0BAh        { DX := 3BAh ( ) }
        in      al, dx
        and     al, 80h
        mov     ah, al          { AH :=  7 (⨪쭠 ᨭ  HGC) }

        mov     cx, 8000h       { ᤥ  32768 ࠧ }
@L41:
        in      al, dx
        and     al, 80h         { 뤥  7 }
        cmp     ah, al
        loope   @L41            {   7-  }

        jne     @L42            { ᫨  7 ,   Hercules }

        mov     al, MDA         { ᫨  7  ,  MDA }
        mov     ah, MDADisplay
        call    @FoundDevice
        jmp     @L44
@L42:
        in      al, dx
        mov     dl, al          { DL := 祭    }

        mov     ah, MDADisplay  { ⠥,   ஬ ᯫ }

        mov     al, HGC         { ᬮਬ 稥 HGC }
        and     dl, 01110000b   { ᪨㥬   4  6 }
        jz      @L43

        mov     al, HGCPlus     { ᬮਬ 稥 HGC+ }
        cmp     dl, 00010000b
        je      @L43            { 室, ᫨  HGC+ }

        mov     al, InColor     {   InColor }
        mov     ah, EGAColorDisplay
@L43:
        call    @FoundDevice
@L44:
        retn

{
 Find6845

 This routine detects the presence of the CRTC on a MDA, CGA or HGC.
 The technique is to write and read register 0Fh of the chip (cursor
 low).  If the same value is read as written, assume the chip is
 present at the specified port addr.
}

@Find6845:                      { 室:       DX = port addr }
                                { 室:      cf ⠭, ᫨  }
        mov     al, 0Fh
        out     dx, al          { 롮 ॣ 0Fh 6845 (Cursor Low) }
        inc     dx
        in      al, dx          { AL := ⥪饥 祭 Cursor Low }
        mov     ah, al          { ࠭  AH }
        mov     al, 66h         { AL := 祭 arbitrary }
        out     dx, al          { ⠥   6845 }

        mov     cx, 100h
@L51:
        loop    @L51            {  ⮢ 6845 }

        in      al, dx
        xchg    ah, al          { AH := 饭 祭 }
                                { AL := ਣ쭮 祭 }
        out     dx, al          { ⠭ ਣ쭮 祭 }

        cmp     ah, 66h         { ஢ઠ ⮢ 6845 }
        je      @L52            { 室, ᫨ ⮢ (cf 襭) }

        stc                     { ⠭ carry flag, ᫨ 6845  }
@L52:
        retn

{
 FindActive

 This subroutine stores the currently active device as Device0.  The
 current video mode determines which subsystem is active.
}

@FindActive:
        cmp     word ptr es:[di+TVID.TVideo1], 0
        je      @L63                    { 室, ᫨ ⮫쪮  ⥬ }

        cmp     es:[di+TVID.TVideo0], 4 { 室 ᫨  MCGA  VGA }
        jge     @L63                    {  ( INT 10H 㭪 1AH }
        cmp     es:[di+TVID.TVideo1], 4 {  㦥 ࠡ⠫ ) }
        jge     @L63

        mov     ah, 0Fh
        int     10h                     { AL := ⥪騩  ० BIOS }

        and     al, 7
        cmp     al, 7                   { 室, ᫨ ஬ }
        je      @L61                    {  (० 7  0Fh) }

        cmp     es:[di+TVID.TDisplay0], MDADisplay
        jne     @L63                    { 室 ᫨ Display0 梥⭮ }
        jmp     @L62
@L61:
        cmp     es:[di+TVID.TDisplay0], MDADisplay
        je      @L63                    { 室 ᫨ Display0 ஬ }
@L62:
        mov     ax, word ptr es:[di+TVID.TVideo0]   { ᤥ ⨢ Device0 }
        xchg    ax, word ptr es:[di+TVID.TVideo1]
        mov     word ptr es:[di+TVID.TVideo0], ax
@L63:
        retn

{
 FoundDevice

  ணࠬ ࠡ뢠 ᯨ᮪ ⥬.
}

@FoundDevice:                           { 室:    AH = # ᯫ }
                                        {          AL = # ⥬ }
                                        { 蠥:  BX  }
        lea     bx, es:[di+TVID.TVideo0]
        cmp     byte ptr es:[bx],0
        je      @L71                    { 室 ᫨ 1 ⥬ }

        lea     bx, es:[di+TVID.TVideo1]   {   2 ⥬ }
@L71:
        mov     es:[bx], ax                { ࠡ ᯨ᮪ }
        retn

@Begin:
        push    ds
        push    cs
        pop     ds

{ 樠  , ᮤঠ १ }

        les     di, ss:[VData]
        mov     word ptr es:[di+TVID.TVideo0], 0
        mov     word ptr es:[di+TVID.TVideo1], 0

        mov     byte ptr [@CGAflag], TRUE
        mov     byte ptr [@EGAflag], TRUE
        mov     byte ptr [@Monoflag], TRUE

	mov	cl, byte ptr @NumberOfTests
        xor     ch, ch
	mov	si, offset @TestSequence
@L01:
        lodsb			{ AL := 䫠 }
	test	al,al
	lodsw			{ AX :=  ணࠬ }
	jz	@L02	        { ய ணࠬ ᫨ 䫠 False }

	push	si
	push	cx
	call	ax		{ 맮 楤  । ⥬ }
	pop	cx
	pop	si
@L02:
        loop	@L01

{ । ⨢ ⥬ }

	call	@FindActive
        pop     ds
end;

{
begin
  TestVideo(Video);
}
end.