/************************************************************************/
/*   		 	DBWin V. 1.0					*/
/*	⥪  ࠡ  䠩 dBASE III  Windows	        */
/*									*/
/*			(C) 1993  			*/
/************************************************************************/

// DBDEFS.HPP -	⠭   

#ifndef __DBDEFS_HPP
#define __DBDEFS_HPP

#ifndef __WINDOWS_H
#include <windows.h>
#endif	 // windows.h

#ifndef HFILE_ERROR
typedef	int	HFILE;			// ᮢ⨬  Windows 3.0
#define HFILE_ERROR ((HFILE) - 1)
#endif

const long MAXREC 	= 1000000000L; 	// ᨬ쭮 ᫮ ᥩ

const FNAMELEN 		= 11;		//   

extern char _RAct_;			// 㠫쭠 
extern char _RDel_;			// 㤠 
				
extern char _EOF_;			//  䠩

enum DBError				//  訡
{
	_ECre_ 	= 10, 	// 訡 ᮧ 
	_EOp_ 	= 11,   // 訡 p 
	_ECl_ 	= 12,   // 訡 p 
	_EIO_ 	= 13,   // 訡 /뢮
	_EFul_ 	= 14,   // 訡 p
	_EMem_ 	= 15,   // 訡 뤥 
	_EFil_	= 16,	// 訡 p  䠩
	_EFld_  = 17 	// 訡 饭    
};

struct DBField					//   
{
	char	 	FName[FNAMELEN+1];   	//  
	char     	FType;    	    	// ⨯  ( .⠡ )
	char		FLength;     	      	//  
	char 		FWidth;			//  p 
};

/*                              
===============================================================================
⨯     祭               	ਬ砭
===============================================================================
C       ᨬ쭮              FWidth == 0
N       ⢥ ᫮                   
D                          	FLength = 8, FWidth = 0,  ࠢ쭮 
				 ⢥砥 짮⥫
L       ᪮          FLength = 1, FWidth = 0, - || -
M	 p	 pᬮp
===============================================================================
*/

class DBase					//  
{
	char        	DBName[9];  		//   ( ७)
	HFILE	    	hDBFile; 		// 䠩 
	long		CurPos;			// ⥪饥  㪠⥫
	unsigned	RecLen; 		//  
	unsigned     	SLine;			// ᫮  ப 
	unsigned long	RecNum;			// ᫮ ᥩ
	unsigned       	FNum;   		// ⢮    
	DBField*    	Field;			// 뫪  ᨢ ⥫ 
						// 

	int 		_err;			//  訡 ࠡ  

	void writedate(HFILE);			//   
	void writeheader(HFILE);		//  

public:
	int TOP;				// p 
	unsigned long BOTTOM;			// ᫥ 

	int   _Append(char*);	       	       	//  
	int   _AppendBlank(void);	       	//   
	int   _Close(void);		       	// p 
	int   _Create(char*, DBField*, int);    // ᮧ 
	int   _Delete(void);		       	// 㤠 
	char* _GetField(char*, char*);		// p 
	char* _GetRec(char*, char*);	       	// p 
	int   _Go(unsigned long);	       	// p 㪠⥫
	int   _Insert(void);			// ⠢ 
	int   _Pack(void);		       	// 㭨⮦ 㤠 
	int   _Recall(void);		       	// ⠭ 
	int   _Replace(char*, char*);		//  
	int   _ReplaceRec(char*, char);	       	//  
	int   _Skip(int = 1);	      	 	// ᤢ 㪠⥫
	int   _Use(char*);			//  
	int   _Zap(void);			// 㤠   

	int   _bof(void)		       	// । 砫 䠩
	{ return CurPos<1 ? TRUE : FALSE; } 

	int   _deleted(void);		       	// ஢   㤠
	char* _dbName(void) {return DBName;}	//   
	int   _eof(void)		       	// p  䠩
	{ return CurPos>RecNum ? TRUE : FALSE; } 

	char* _error(void);		      	// p⪠ 訡
	char* _getFName(unsigned fn)		// ।   (>=1)
	{ return fn<=FNum ? (Field+fn-1)->FName : (Field+FNum-1)->FName; }

	int   _getFNum(void) {return FNum;}	// । ᫮  
						//  
	long _getFLen(unsigned fn)		// ।   (>=1)
	{ return fn<=FNum ? MAKELONG((Field+fn-1)->FLength, 
				    (Field+fn-1)->FWidth) :
			   MAKELONG((Field+FNum-1)->FLength, 
				    (Field+FNum-1)->FWidth); }

	char  _getFType(unsigned fn)		// । ⨯  (>=1)
	{ return fn<=FNum ? (Field+fn-1)->FType : (Field+FNum-1)->FType; }

	long  _reccount(void) {return RecNum;}	//  ᫮ ᥩ
	long  _recno(void) {return CurPos;}	// p ⥪.  
						// 㪠⥫
};
#endif	 //dbdefs.hpp
