//------------------------------------------------------------------
//   CALLBACK.C
//
//   (C)1992-93 ᠭ ન
//   ⥫. (056-72)37-110, (056-72)37-702 (ࠡ稥)
//
//   Callback -    callback.  ⮬ 㫥 -  ᯮ-
//    ASSOCSRV.EXE 㭪樨 - 㭪樨   ॣ஢-
//    ᮢ, 㭪樨  
//
//   : BC++ 3.1
//------------------------------------------------------------------


#define STRICT

#include <windows.h>
#include <windowsx.h>

#pragma hdrstop
#include <dde.h>
#include <commdlg.h>
#include <string.h>
#include "cntrls.h"
#include "assocsrv.h"
#include "handler.h"
#include "callback.h"


// p楤p   pp
LRESULT CALLBACK WndProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam){
  extern BOOL    bNeedConfigure;
  extern char*   szApp;
  extern char*   szTopic;
  extern char*   szItem;
  extern char*   szAppName;
  extern char    szFile [MAXTOPIC];
  extern HINSTANCE   hInst;

  char         szItemName [20];
  ATOM         aApp,
               aTopic,
               aItem;
  HANDLE       hPokeData;
  DDEPOKE FAR *lpPokeData;
  BOOL         bRelease;
  DLGPROC      lpDlg;
  LRESULT      lRetValue = 0L;


  switch (message) {
         case WM_ACTIVATE:
              // ᫨ ⠢ ᮮ⢥騩 䫠 - 뫠 ᥡ ᮮ-
              // 饭  室 뢮  䨣p樨
              if (bNeedConfigure){
                 PostMessage (hWnd, WM_CONFIGUREDIALOG, 0, 0L);
                 bNeedConfigure = FALSE;}
              break;

         case WM_DDE_INITIATE:
              // p  樠 DDE
              // ᮧ ⮬  p
              if (!(aApp = GlobalAddAtom ((LPSTR) szApp)))
                 return 0L;
              // ᮧ ⮬  ⥬
              if (!(aTopic = GlobalAddAtom ((LPSTR) szTopic))){
                 GlobalDeleteAtom (aApp);
                 return 0L;}
              // ᫨   ᮢ  pᮬ  -  p-
              // p  
              if ((aApp != LOWORD (lParam)) || (aTopic != HIWORD (lParam))){
                 GlobalDeleteAtom (aApp);
                 GlobalDeleteAtom (aTopic);
                 return 0;}
              //  ᫨  p쭮 - 뫠 ᮮ饭  ⢥p
              SendMessage ((HWND)wParam, WM_DDE_ACK, (WPARAM)hWnd, MAKELPARAM (aApp, aTopic));
              break;

         case WM_DDE_POKE:
              //  p ᮮ饭
              // 砥 handle pp DDEPOKE
              hPokeData = (HGLOBAL)LOWORD (lParam);
              // 砥  ⮬ ...
              aItem = HIWORD (lParam);
              // ...   
              GlobalGetAtomName (aItem, (LPSTR)szItemName, 20);
              // ᫨  p襫 GlobalLock ...
              if (!(lpPokeData = (DDEPOKE FAR *)GlobalLock (hPokeData))
                  // ...  p  -  ⥪ ...
                  || lpPokeData->cfFormat != CF_TEXT
                  // ...     ⮬
                  || lstrcmp ((LPSTR)szItemName, (LPSTR)szItem)){
                     // ᮮ頥  ⮬
                     MessageBox (hWnd, "Can't retrieve client string",
                                 szAppName, MB_ICONSTOP|MB_OK);
                     //  ᮮ頥   ᯮ碥  p⥭
                     PostMessage ((HWND)wParam, WM_DDE_ACK, (WPARAM)hWnd, MAKELONG (0,aItem));
                     return 0;}
              // ᫨  p쭮, 砥 p  pp DDEPOKE
              lstrcpy ((LPSTR) szFile, lpPokeData->Value);
              // CF_TEXT p蠥 p CP-LF, ᥪ 
              szFile [lstrlen ((LPSTR)szFile) - 2] = '\0';
              // 砥 p ⮣,   pp ᢮ 
              bRelease = lpPokeData->fRelease;
              GlobalUnlock (hPokeData);

              // ᫨  - 㤠塞 hPokeData   ⮬
              if (bRelease){
                 GlobalFree (hPokeData);
                 GlobalDeleteAtom (aItem);}
              // ᮮ頬 ,   OK
              PostMessage ((HWND)wParam, WM_DDE_ACK, (WPARAM)hWnd, MAKELPARAM (0x8000, aItem));
              //  p  䠩
              ProcessIt (hWnd);
              break;

         case WM_SYSCOMMAND:
              // p諠   ⥬ 
              switch (wParam & 0xfff0) {
                     // Microsoft p  室  ⮬ 砥 -
                     // p 4 訥   wParam
                     case IDM_ABOUT:
                          // 뢮 About Dialog Box
                          lpDlg = (DLGPROC)MakeProcInstance ((FARPROC)About, hInst);
                          DialogBox (hInst,
                                     MAKEINTRESOURCE (ABOUT_DLG),
                                     hWnd,
                                     lpDlg);
                          FreeProcInstance ((FARPROC)lpDlg);
                          break;

                     case SC_RESTORE:
                     case SC_MAXIMIZE:
                          //    ⥬  ⢥砥 ᢮
                          // ᮮ饭
                          PostMessage (hWnd, WM_CONFIGUREDIALOG, 0, 0L);
                          lRetValue = 0L;
                          break;

                     default:
                             lRetValue = DefWindowProc (hWnd, message, wParam, lParam);}
              break;

         case WM_CONFIGUREDIALOG:
              // 뢮 Configure Dialog
              lpDlg = (DLGPROC)MakeProcInstance ((FARPROC)Config, hInst);
              DialogBox (hInst,
                         MAKEINTRESOURCE (MAIN_DLG),
                         hWnd,
                         lpDlg);
              FreeProcInstance ((FARPROC)lpDlg);
              break;

         case WM_DESTROY:
              //  p뢠, 㤠塞 ᨢ
              DestroyArray ();
              PostQuitMessage (0);
              break;

         default:
                 lRetValue = DefWindowProc (hWnd, message, wParam, lParam);}
  return lRetValue;
}



// p楤p , 뢮饣 Popup menu  p뢠饣  
LRESULT CALLBACK MenuWndProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
        extern LPEXTCONTROL        lpContArray;
        extern LPMENUCH            lpCurrentChain;
        extern char                szFile[MAXLINE];

        static POINT               pCorner;
               HMENU               hMenu;
               LPMENUCH            lpMen;
               LRESULT             lRetVal;
               CREATESTRUCT FAR*   lpCrt;
               char                szComLine [MAXLINE];
               int                 i;
               int                 nStyle;

        switch (message) {
               case WM_CREATE:
                    // p塞 p  p孥 㣫 
                    lpCrt = (CREATESTRUCT FAR*)lParam;
                    pCorner.x = lpCrt->x;
                    pCorner.y = lpCrt->y;
                    lRetVal = 0L;
                    break;

               case WM_SETFOCUS:
                    //  ᮧ, 砥 䮪 
                    // ᮧ Popup menu
                    if (lpCurrentChain->lpNext){ // ᫨  1- p⨢
                       if ((hMenu = CreatePopupMenu ()) != (HMENU)NULL){
                          for (i = 0, lpMen = lpCurrentChain ; lpMen ; lpMen = lpMen->lpNext, i++)
                              AppendMenu (hMenu, MF_ENABLED, IDM_FIRST + i, lpMen->lpMenuItem);
                          TrackPopupMenu (hMenu, TPM_LEFTALIGN, pCorner.x, pCorner.y, NULL, hWnd, NULL);
                          DestroyMenu (hMenu);}}
                    else  //  p⨢ 砥 - p 뫠 
                         PostMessage (hWnd, WM_COMMAND, IDM_FIRST, 0L);
                    //    㦭 - p뢠
                    PostMessage (hWnd, WM_CLOSE, 0, 0L);
                    lRetVal = 0L;
                    break;

               case WM_CLOSE:
                    DestroyWindow (hWnd);
                    lRetVal = 0L;

               case WM_COMMAND:
                    // p諠   
                    if (wParam >= IDM_FIRST)
                       // 砥  p   p⨢
                       if (GetCommandLine (lpCurrentChain, wParam - IDM_FIRST, szComLine, &nStyle)){
                          lstrcat ((LPSTR) szComLine, (LPSTR) " ");
                          lstrcat ((LPSTR) szComLine, (LPSTR) szFile);
                          WinExec ((LPSTR) szComLine, nStyle);}
                    lRetVal = 0L;
                    break;

               default:
                       lRetVal = DefWindowProc (hWnd, message, wParam, lParam);}

        return lRetVal;
}

// p楤p  About
#pragma argsused
BOOL CALLBACK About (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam){

  switch (message){
         case WM_INITDIALOG:
              return TRUE;

         case WM_COMMAND:
              if (wParam == IDOK || wParam == IDCANCEL) {
                 EndDialog (hDlg, TRUE);
                 return TRUE;}}
  return FALSE;
}


// p楤p  䨣p樨
BOOL CALLBACK Config (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) {
     BOOL     bRetValue = FALSE;

     switch (message) {
            case WM_INITDIALOG:
                 // p 樠樨 - 塞 List Boxes
                 FillControls (hDlg);
                 bRetValue = TRUE;
                 break;

            case WM_COMMAND:
                 // ᫨ p諮 ᮮ饭  Control'a - p ᮮ⢥-
                 // 饩 p楤p p⪨
                 switch (wParam) {
                        case EXT_LIST:
                             HandleExtList (hDlg, lParam);
                             bRetValue = TRUE;
                             break;

                        case MENU_LIST:
                             HandleMenuList (hDlg, lParam);
                             bRetValue = TRUE;
                             break;

                        case SAVE_BUT:
                             HandleSave ();
                             bRetValue = TRUE;
                             break;

                        case EDIT_BUT:
                             HandleEdit (hDlg);
                             bRetValue = TRUE;
                             break;

                        case APPEND_BUT:
                             HandleAppend (hDlg);
                             bRetValue = TRUE;
                             break;

                        case DELETE_BUT:
                             HandleDelete (hDlg);
                             bRetValue = TRUE;
                             break;

                         case IDCANCEL:
                             if (HandleClose (hDlg)){
                                EndDialog (hDlg, 0);}
                             bRetValue = TRUE;}}

     return bRetValue;
}


// p楤p  pp pp
#define      EXT_LEN 4
BOOL CALLBACK EditExtension (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
     extern   BOOL          bChanged;
     extern   LPEXTCONTROL  lpContArray;

     static   HWND          hParent;
     static   int           nIndex;
     static   LPCSTR        lpBuffer;
     static   BOOL          bTextChanged;
              BOOL          bRetVal = FALSE;
              BOOL          bDummy;

     switch (msg) {
            case WM_INITDIALOG:
                 hParent = GetParent (hWnd);
                 // 砥  뤥   ᯨ᪠ pp
                 nIndex = (int)SendDlgItemMessage (hParent, EXT_LIST, LB_GETCURSEL, 0, 0L);
                 // 뤥塞 p  p
                 lpBuffer = (LPCSTR)GlobalAllocPtr (GHND, EXT_LEN);
                 // 塞 p
                 SendDlgItemMessage (hParent, EXT_LIST, LB_GETTEXT, nIndex, (LPARAM)lpBuffer);
                 //  p   Edit Control
                 SendDlgItemMessage (hWnd, EXT_TEXT, WM_SETTEXT, 0, (LPARAM)lpBuffer);
                 break;

            case WM_COMMAND:
                 switch (wParam) {
                        case EXT_TEXT:
                             if (HIWORD (lParam) == EN_CHANGE) {
                                // ⬥砥,  뫨 
                                bTextChanged = TRUE;
                                bRetVal = TRUE;}
                             break;

                        case IDOK:
                             // H OK, 㦭  p,
                             // ᫨ 뫨 
                             if (bTextChanged) {
                                // 塞 p  祭
                                SendDlgItemMessage (hWnd, EXT_TEXT, WM_GETTEXT, EXT_LEN, (LPARAM)lpBuffer);
                                // 塞 p  ᨢ ...
                                lstrcpy (lpContArray[nIndex].szExtension, lpBuffer);
                                // ...   ᯨ᪥ pp
                                SendDlgItemMessage (hParent, EXT_LIST, LB_DELETESTRING, nIndex, 0L);
                                SendDlgItemMessage (hParent, EXT_LIST, LB_INSERTSTRING, nIndex, (LPARAM)(LPCSTR)(lpContArray[nIndex].szExtension));
                                bChanged = TRUE;}
                             bDummy = GlobalFreePtr (lpBuffer);
                             EndDialog (hWnd, 1);
                             bRetVal = TRUE;
                             break;

                        case IDCANCEL:
                             // p頥 
                             bDummy = GlobalFreePtr (lpBuffer);
                             // 稢  
                             EndDialog (hWnd, 0);
                             bRetVal = TRUE;}}

     return bRetVal;
}


// p楤p     ᯨ᮪ pp
BOOL CALLBACK AppendExtension (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
     extern   BOOL          bChanged;
     extern   LPEXTCONTROL  lpContArray;
     extern   int           nContArrSize;

     static   HWND          hParent;
     static   LPCSTR        lpBuffer;
     static   BOOL          bTextChanged;
              BOOL          bRetVal = FALSE;
              BOOL          bDummy;
              int           nIndex;

     switch (msg) {
            case WM_INITDIALOG:
                 hParent = GetParent (hWnd);
                 // 뤥塞 p  p
                 lpBuffer = (LPCSTR)GlobalAllocPtr (GHND, EXT_LEN);
                 // p   Edit Control
                 SendDlgItemMessage (hWnd, EXT_TEXT, WM_SETTEXT, 0, (LPARAM)lpBuffer);
                 break;

            case WM_COMMAND:
                 switch (wParam) {
                        case EXT_TEXT:
                             if (HIWORD (lParam) == EN_CHANGE) {
                                // ⬥砥,  뫨 
                                bTextChanged = TRUE;
                                bRetVal = TRUE;}
                             break;

                        case IDOK:
                             // H OK, 㦭  p,
                             // ᫨ 뫨 
                             if (bTextChanged) {
                                // 塞 p  祭
                                SendDlgItemMessage (hWnd, EXT_TEXT, WM_GETTEXT, EXT_LEN, (LPARAM)lpBuffer);
                                // p塞 ᨢ
                                nContArrSize = ExpandArray ((LPVOID)&lpContArray, nContArrSize, sizeof (EXTCONTROL), 1);
                                // 塞 p  ᨢ ...
                                lstrcpy (lpContArray[nContArrSize - 1].szExtension, lpBuffer);
                                // ...   ᯨ᮪ pp
                                SendDlgItemMessage (hParent, EXT_LIST, LB_ADDSTRING, 0, (LPARAM)lpBuffer);
                                nIndex = (int)SendDlgItemMessage (hParent, EXT_LIST, LB_GETCOUNT, 0, 0L);
                                SendDlgItemMessage (hParent, EXT_LIST, LB_SETCURSEL, nIndex - 1, 0L);
                                bChanged = TRUE;}
                             bDummy = GlobalFreePtr (lpBuffer);
                             EndDialog (hWnd, 1);
                             bRetVal = TRUE;
                             break;

                        case IDCANCEL:
                             // p頥 
                             bDummy = GlobalFreePtr (lpBuffer);
                             // 稢  
                             EndDialog (hWnd, 0);
                             bRetVal = TRUE;}}

     return bRetVal;
}

// p楤p  pp 㭪    p
BOOL CALLBACK EditMenu (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
     extern   BOOL          bChanged;
     extern   LPEXTCONTROL  lpContArray;
     extern   char*         szFilter;
     extern   char*         szHeader;

     static   HWND          hParent;
     static   int           nExtIndex;
     static   int           nMenuIndex;
     static   BOOL          bTextChanged;
     static   LPMENUCH      lpCurrent;
              LPCSTR        lpItemBuffer;
              LPCSTR        lpCommandBuffer;
              BOOL          bRetVal = FALSE;
              BOOL          bDummy;
              int           nFlag = 0;
              int           i=0;
              OPENFILENAME  ofn;
              char          szCommand [MAXLINE];

     switch (msg) {
            case WM_INITDIALOG:
                 hParent = GetParent (hWnd);
                 // 砥  뤥   ᯨ᪠ pp
                 nExtIndex = (int)SendDlgItemMessage (hParent, EXT_LIST, LB_GETCURSEL, 0, 0L);
                 // 砥   ᯨ᪠ ⮢ 
                 nMenuIndex = (int)SendDlgItemMessage (hParent, MENU_LIST, LB_GETCURSEL, 0, 0L);
                 // 室 㦭   ᨢ
                 for (lpCurrent = lpContArray[nExtIndex].lpChain ; (i < nMenuIndex) && lpCurrent ; i++, lpCurrent = lpCurrent->lpNext);
                 SendDlgItemMessage (hWnd, MENU_ITEM, WM_SETTEXT, 0, (LPARAM)(lpCurrent->lpMenuItem));
                 SendDlgItemMessage (hWnd, COMM_LINE, WM_SETTEXT, 0, (LPARAM)(lpCurrent->lpCommand));
                 SetStyles (hWnd, lpCurrent->nStyle);
                 break;

            case WM_COMMAND:
                 switch (wParam) {
                        case MENU_ITEM:
                        case COMM_LINE:
                             if (HIWORD (lParam) == EN_CHANGE) {
                                // ⬥砥,  뫨 
                                bTextChanged = TRUE;
                                bRetVal = TRUE;}
                             break;

                        case BROWSE_BUT:
                             //  BROWSE -   p
                             //    pp ﬨ
                             memset (&ofn, 0, sizeof (OPENFILENAME));
                             szCommand [0] = '\0';

                             ofn.lStructSize = sizeof (OPENFILENAME); // pp pp
                             ofn.hwndOwner = hWnd;                    // -
                             ofn.lpstrFilter = (LPCSTR)szFilter;      // p 䨫p
                             ofn.lpstrFile = (LPSTR)szCommand;        // p   䠩
                             ofn.nMaxFile = sizeof (szCommand);       // pp p
                             ofn.lpstrTitle = (LPCSTR)szHeader;       //  
                             ofn.Flags = OFN_FILEMUSTEXIST |          // 䠩  ⢮
                                         OFN_HIDEREADONLY |           //  뢠 Read Onle check box
                                         OFN_PATHMUSTEXIST;           // pp pp⭮   䠩

                             if (GetOpenFileName (&ofn)){
                                // p 䠩, ⥯p   㦭
                                // ᪮p  COMM_LINE Edit Control
                                SendDlgItemMessage (hWnd, COMM_LINE, WM_SETTEXT, 0, (LPARAM)(LPCSTR)szCommand);
                                SetFocus (GetDlgItem (hWnd, COMM_LINE));}

                             bTextChanged = TRUE;
                             bRetVal = TRUE;
                             break;

                        case IDOK:
                             if (bTextChanged){
                                // 㦭    ᮮ⢥騥  ᯨ᪠
                                // ᭠砫 뤥 p
                                lpItemBuffer = (LPCSTR)GlobalAllocPtr (GHND, MAXLINE);
                                lpCommandBuffer = (LPCSTR)GlobalAllocPtr (GHND, MAXLINE);
                                // 塞   Edit Controls
                                SendDlgItemMessage (hWnd, MENU_ITEM, WM_GETTEXT, MAXLINE, (LPARAM)lpItemBuffer);
                                SendDlgItemMessage (hWnd, COMM_LINE, WM_GETTEXT, MAXLINE, (LPARAM)lpCommandBuffer);

                                // ⥯p 㦭 㤠 p 祭
                                //    ⠢ 
                                // 㬥蠥 Lock Count  0
                                bDummy = GlobalFreePtr (lpCurrent->lpCommand);
                                bDummy = GlobalFreePtr (lpCurrent->lpMenuItem);

                                lpCurrent->lpCommand = (char far*)lpCommandBuffer;
                                lpCurrent->lpMenuItem = (char far*)lpItemBuffer;

                                // 砥  ⨫ ᪠
                                lpCurrent->nStyle = (int)SendDlgItemMessage (hWnd, RUN_STYLE, CB_GETCURSEL, 0, 0L);

                                // , , 塞 ᯨ᮪ MENU_LIST
                                SendDlgItemMessage (hParent, MENU_LIST, LB_DELETESTRING, nMenuIndex, 0L);
                                SendDlgItemMessage (hParent, MENU_LIST, LB_INSERTSTRING, nMenuIndex, (LPARAM)lpItemBuffer);

                                // ⠢塞 p ᥭ 
                                bChanged = TRUE;
                                nFlag = 1;}
                             bRetVal = TRUE;
                             EndDialog (hWnd, nFlag);
                             break;

                        case IDCANCEL:
                             bRetVal = TRUE;
                             EndDialog (hWnd, nFlag);}}
     return bRetVal;
}

// p楤p    㭪    p⪨
BOOL CALLBACK AppendMenuItem (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
     extern   BOOL          bChanged;
     extern   LPEXTCONTROL  lpContArray;
     extern   char*         szFilter;
     extern   char*         szHeader;

     static   HWND          hParent;
     static   BOOL          bTextChanged;
     static   LPMENUCH      lpCurrent;
     static   LPCSTR        lpItemBuffer;
     static   LPCSTR        lpCommandBuffer;
              BOOL          bRetVal = FALSE;
              BOOL          bDummy;
              int           i,
                            nIndex;
              OPENFILENAME  ofn;
              char          szCommand [MAXLINE];

     switch (msg) {
            case WM_INITDIALOG:
                 hParent = GetParent (hWnd);
                 // p塞 p   p   p⪨
                 lpItemBuffer = (LPCSTR)GlobalAllocPtr (GHND, MAXLINE);
                 lpCommandBuffer = (LPCSTR)GlobalAllocPtr (GHND, MAXLINE);
                 // 塞 Edit Controls
                 SendDlgItemMessage (hWnd, MENU_ITEM, WM_SETTEXT, 0, (LPARAM)lpItemBuffer);
                 SendDlgItemMessage (hWnd, COMM_LINE, WM_SETTEXT, 0, (LPARAM)lpCommandBuffer);
                 SetStyles (hWnd, 0);
                 break;

            case WM_COMMAND:
                 switch (wParam) {
                        case MENU_ITEM:
                        case COMM_LINE:
                             if (HIWORD (lParam) == EN_CHANGE) {
                                // ⬥砥,  뫨 
                                bTextChanged = TRUE;
                                bRetVal = TRUE;}
                             break;

                        case BROWSE_BUT:
                             //  BROWSE -   p
                             //    pp ﬨ
                             memset (&ofn, 0, sizeof (OPENFILENAME));
                             szCommand [0] = '\0';

                             ofn.lStructSize = sizeof (OPENFILENAME); // pp pp
                             ofn.hwndOwner = hWnd;                    // -
                             ofn.lpstrFilter = (LPCSTR)szFilter;      // p 䨫p
                             ofn.lpstrFile = (LPSTR)szCommand;        // p   䠩
                             ofn.nMaxFile = sizeof (szCommand);       // pp p
                             ofn.lpstrTitle = (LPCSTR)szHeader;       //  
                             ofn.Flags = OFN_FILEMUSTEXIST |          // 䠩  ⢮
                                         OFN_HIDEREADONLY |           //  뢠 Read Onle check box
                                         OFN_PATHMUSTEXIST;           // pp pp⭮   䠩

                             if (GetOpenFileName (&ofn)){
                                // p 䠩, ⥯p   㦭
                                // ᪮p  COMM_LINE Edit Control
                                SendDlgItemMessage (hWnd, COMM_LINE, WM_SETTEXT, 0, (LPARAM)(LPCSTR)szCommand);
                                SetFocus (GetDlgItem (hWnd, COMM_LINE));}

                             bTextChanged = TRUE;
                             bRetVal = TRUE;
                             break;

                        case IDOK:
                             if (bTextChanged){
                                // 㦭    ᮮ⢥騥  ᯨ᪠
                                // 塞  Edit Controls
                                SendDlgItemMessage (hWnd, MENU_ITEM, WM_GETTEXT, MAXLINE, (LPARAM)lpItemBuffer);
                                SendDlgItemMessage (hWnd, COMM_LINE, WM_GETTEXT, MAXLINE, (LPARAM)lpCommandBuffer);

                                if (lpItemBuffer [0] && lpCommandBuffer [0]) {
                                   // ᫨  p   -
                                   // 㦭     ᯨ᮪
                                   nIndex = (int)SendDlgItemMessage (hParent, EXT_LIST, LB_GETCURSEL, 0, 0L);
                                   // 塞    ᯨ᮪
                                   lpCurrent = AppendList (nIndex);
                                   // 塞 
                                   lpCurrent->lpMenuItem = (char far*)lpItemBuffer;
                                   lpCurrent->lpCommand = (char far*)lpCommandBuffer;
                                   lpCurrent->nStyle = (int)SendDlgItemMessage (hWnd, RUN_STYLE, CB_GETCURSEL, 0, 0L);

                                   // , , 塞 ᯨ᮪ MENU_LIST
                                   SendDlgItemMessage (hParent, MENU_LIST, LB_ADDSTRING, 0, (LPARAM)lpItemBuffer);

                                   // ⠢塞 p ᥭ 
                                   bChanged = TRUE;}}
                             bRetVal = TRUE;
                             EndDialog (hWnd, 1);
                             break;

                        case IDCANCEL:
                             bDummy = GlobalFreePtr (lpItemBuffer);
                             bDummy = GlobalFreePtr (lpCommandBuffer);
                             bRetVal = TRUE;
                             EndDialog (hWnd, 0);}}
     return bRetVal;
}



