//------------------------------------------------------------------
//   UTILS.C
//
//   (C)1992-93 ᠭ ન
//   ⥫. (056-72)37-110, (056-72)37-702 (ࠡ稥)
//
//   ᯮ⥫ 㭪樨  ASSOCSRV.EXE (,   
//    㣨 㫨,   ࠢ 㦭  ࠡ).  -
//   ࠧ - 㭪樨 樨  ࠬ  ணࠬ 
//   ࠡ⪨ 祭    䠩
//
//   : BC++ 3.1
//------------------------------------------------------------------
#define STRICT

#include <windows.h>
#include <windowsx.h>
#pragma  hdrstop

#include "cntrls.h"
#include "assocsrv.h"


// 㭪 㤠 ᨢ lpContArray
void DestroyArray (void){
     extern       int    nContArrSize;
     extern       LPEXTCONTROL        lpContArray;

     int          nIter;
     BOOL         bDummy;

     for (nIter = 0 ; nIter < nContArrSize ; nIter++)
         // 㤠塞  ᯨ᪨
         if (lpContArray [nIter].lpChain)
            DestroyMenuCh (lpContArray [nIter].lpChain);

     bDummy = GlobalFreePtr (lpContArray);
     nContArrSize = 0;
     lpContArray = (LPEXTCONTROL)NULL;
}



// 㭪 㤠 ᯨ᮪,  p 㪠뢠 lpChain
void DestroyMenuCh (LPMENUCH lpChain){
     BOOL         bDummy;

     if (lpChain->lpNext)
        // ppᨢ 맮
        DestroyMenuCh (lpChain->lpNext);

     bDummy = GlobalFreePtr (lpChain->lpMenuItem);
     bDummy = GlobalFreePtr (lpChain->lpCommand);

     bDummy = GlobalFreePtr (lpChain);
}


// 㭪  ᢮   砥 㤠 p ⥭ INI-䠩
void  DestroyStructure (LPSTR lpFirst, LPSTR lpSecond){
      extern           LPMENUCH        lpCurrentChain;

      BOOL             bDummy;


     if (lpFirst)
        bDummy = GlobalFreePtr (lpFirst);

     if (lpSecond)
        bDummy = GlobalFreePtr (lpSecond);

     DestroyArray ();

}



// 㭪 p ᨢ  nBy ⮢,   p
//  pp nSizeOf
UINT ExpandArray (LPVOID* lpArray, UINT uArrSize, UINT uSizeOf, UINT uBy) {

     if (*lpArray)                // ᫨ ᨢ  - p
        *lpArray = GlobalReAllocPtr (*lpArray, (uArrSize  + uBy) * uSizeOf, GHND);
     else                        //  ᫨  - ᮧ
         *lpArray = GlobalAllocPtr (GHND, (uArrSize  + uBy) * uSizeOf);

     return (uArrSize + uBy);
}


// 㭪     ᯨ᮪, 㪠⥫  p -
//   쭮 ᨢ   nIndex. p頥 㪠⥫
//   , ᫨  p諮 ᯥ譮  (LPMENUCH)NULL, ᫨
// -  ⠪
LPMENUCH AppendList (int nIndex) {
         extern     LPEXTCONTROL lpContArray;
         extern     int          nContArrSize;
                    int          i;
                    LPMENUCH     lpCurrent,
                                 lpRetVal = (LPMENUCH) NULL;

         if (nIndex >= nContArrSize)
            return lpRetVal;

         // ᭠砫 뤥塞 㦭 
         lpRetVal = (LPMENUCH)GlobalAllocPtr (GHND, sizeof (MENUCH));
         if (lpRetVal) {
            // 饬 ᫥   ᯨ᪥
            if (lpContArray[nIndex].lpChain) {
               for (lpCurrent = lpContArray[nIndex].lpChain ; lpCurrent->lpNext ; lpCurrent = lpCurrent->lpNext);
               lpCurrent->lpNext = lpRetVal;}
            else {
                 lpContArray[nIndex].lpChain = lpRetVal;}}

         return lpRetVal;
}

#define         DEF_WIDTH       2
#define         DEF_HEIGHT      2
// 㭪 ᮧ   szMenuClass
void ProcessIt (HWND hWnd) {
     extern    HINSTANCE    hInst;
     extern    LPMENUCH     lpCurrentChain;
     extern    LPEXTCONTROL lpContArray;
     extern    int          nContArrSize;
     extern    char         szFile[MAXLINE];
     extern    char*        szAppName;
     extern    char*        szMenuClass;

     static    HWND         hMenuWind;
               POINT        CurPlace;
               char         szExt [4];
               char         cText [40];


     // 砥 pp   䠩
     GetExtension (szFile, szExt);

     if (!(lpCurrentChain = SearchExtension (szExt))){
        // ᫨  諨  ᨢ - 뢮 ᮮ饭
        wsprintf ((LPSTR)cText, (LPSTR)"%s : Can't process this extension", (LPSTR)szExt);
        MessageBox (hWnd, (LPSTR)cText,(LPSTR)szAppName,MB_ICONEXCLAMATION | MB_OK);}
     else {
         GetCursorPos ((LPPOINT) (&CurPlace));
         hMenuWind = CreateWindow (szMenuClass,           // window class
                                   NULL,                  // window title
                                   WS_POPUP,              // window style
                                   CurPlace.x,            // window upper-left
                                   CurPlace.y,            // corner
                                   DEF_WIDTH,             // window width
                                   DEF_HEIGHT,            // window height
                                   HWND_DESKTOP,          // required for pop-up windows that does not have owner
                                   NULL,                  // no menu
                                   hInst,
                                   NULL);
         if (hMenuWind)
            ShowWindow (hMenuWind, SW_SHOW);}
}

// 㭪 p  䠩  p  p  p pp
void GetExtension (char *szFile, char *szBuf){
     int          nLen,
                  nIter;

     szBuf [0] = '\0';
     for (nIter = lstrlen (szFile) - 1 ; nIter > 0 ; nIter--)
         if (szFile [nIter] == '.')  break;

     lstrcpy ((LPSTR)szBuf, (LPSTR)(szFile + nIter + 1));
     return;
}


// 㭪 ⢫   ᨢ lpContArray
// p頥 㪠⥫  ᯨ᮪   pp  NULL
// ᫨ pp  
LPMENUCH SearchExtension (char *szExt){
         extern  int     nContArrSize;
         extern  LPEXTCONTROL lpContArray;

         int       nIter;
         LPMENUCH  lpRet = (LPMENUCH)0L;

         for (nIter = 0 ; nIter < nContArrSize ; nIter++)
             if (!lstrcmpi ((LPSTR) szExt, (LPSTR)lpContArray[nIter].szExtension)){
                lpRet = lpContArray[nIter].lpChain;
                break;}

         return lpRet;
}


//   szCommand  p  ᪠,  nStyle
// pᢠ ⠭ ⨫ ᪠
BOOL GetCommandLine (LPMENUCH lpChain, UINT wNumber, char *szCommand, int* nStyle){
extern RUNSTYLES    rsStyles [STYLE_NUM];

     UINT           nIter = 0;
     BOOL           bRet = FALSE;
     LPMENUCH       lpCurr = lpChain;

     for (nIter = 0; (nIter < wNumber) && lpCurr ; nIter++, lpCurr = lpCurr->lpNext);

     if (lpCurr){
        lstrcpy ((LPSTR)szCommand, lpCurr->lpCommand);
        *nStyle = rsStyles[lpCurr->nStyle].nStyleConst;
        bRet = TRUE;}

     return bRet;
}


// 㭪  㭪 About  ⥬ 
void MakeMyMenu (HWND hWnd) {

     HMENU      hSysMenu;

     if (!(hSysMenu = GetSystemMenu (hWnd, 1)))
        if (!(hSysMenu = GetSystemMenu (hWnd, 0)))  return;

     AppendMenu (hSysMenu, MF_SEPARATOR, 0, (LPCSTR)NULL);
     AppendMenu (hSysMenu, MF_ENABLED, IDM_ABOUT, (LPSTR)"&About Assoc");
}


// 㭪 뢠   List Box  ᯨ᪮ pp
LRESULT FillControls (HWND hWnd) {
        extern       int          nContArrSize;
        extern       LPEXTCONTROL lpContArray;

                     int          i;
                     LRESULT      lRetValue = 0;

        // 砫 㤠塞  ᮤp
        SendDlgItemMessage (hWnd, EXT_LIST, LB_RESETCONTENT, 0, 0L);

        //  ⥬ 塞 
        for (i = 0 ; i < nContArrSize ; i++)
            if (SendDlgItemMessage (hWnd,
                                    EXT_LIST,
                                    LB_ADDSTRING,
                                    (WPARAM)0,
                                    (LPARAM)(LPCSTR)lpContArray[i].szExtension) == CB_ERR){
               lRetValue = -1L;
               break;}

        // ⠭ 롮p  0- 
        if (lpContArray)
            SendDlgItemMessage (hWnd, EXT_LIST, LB_SETCURSEL, 0, 0L);

        // 塞 ᯨ᮪ p⨢ 
        if (lRetValue != -1L)
           lRetValue = ShowCommands (hWnd, 0);

        return lRetValue;
}

// 㭪  List Box  ᯨ᪮ p⨢   
// ᨢ  p nIndex
LRESULT ShowCommands (HWND hWnd, int nIndex) {
        extern       int               nContArrSize;
        extern       LPEXTCONTROL      lpContArray;

                     LRESULT           lRetValue = -1L;
                     LPMENUCH          lpCurrChain;
                     LRESULT           lItems;

        // 砫 㤠塞  ᮤp ᯨ᪠ 
        SendDlgItemMessage (hWnd, MENU_LIST, LB_RESETCONTENT, 0, 0L);

        // pp塞 
        if (nIndex >= nContArrSize)
           return lRetValue;

        //  ⥯p 塞  Menu Items   pp
        if (lpContArray[nIndex].lpChain) {
           for (lpCurrChain = lpContArray[nIndex].lpChain; lpCurrChain ; lpCurrChain = lpCurrChain->lpNext)
               if (SendDlgItemMessage (hWnd,
                                       MENU_LIST,
                                       LB_ADDSTRING,
                                       0,
                                       (LPARAM)(LPCSTR)lpCurrChain->lpMenuItem) == LB_ERR)
                  return lRetValue;
           // ⠭ ⥪騩 롮p
           SendDlgItemMessage (hWnd, MENU_LIST, LB_SETCURSEL, 0, 0L);}


        return (lRetValue == 0);
}


// 㭪 p 쭨 㪠⥫  p    
// ᨬ ';', ᫨ 室 - p  p頥  ⨫ -
// ᪠  ᨢ rsStyles, ᫨    - p頥 SW_SHOW
int ExtractStyle (LPSTR lpString) {
    extern       RUNSTYLES        rsStyles [3];

    int          nRetValue = 0;            //  SW_SHOW
    int          nLen;
    int          i;
    LPSTR        lpBuffer = (LPSTR)NULL;
    char         cMax = '0' + STYLE_NUM;

    nLen = lstrlen (lpString);
    for (i = 0; i < nLen ; i++)
        if (lpString [i] == ';'){
           lpBuffer = lpString + i + 1;     // ⠭ 㪠⥫  ᫥騩 
           lpString [i] = '\x0';            //  p㡨 p
           break;}

    if (lpBuffer)                           // ᫨ 諨
       if ((lpBuffer [0] < cMax) && (lpBuffer [0] >= '0'))
          nRetValue = lpBuffer[0] - '0';         // ⠪   !

    return nRetValue;
}








