


	       STEVIE - An Aspiring VI Clone

		   User Reference - 3.69a

			Tony Andrews




1.  _O_v_e_r_v_i_e_w

STEVIE is an editor designed to mimic the interface  of  the
UNIX  editor  'vi'.  The name (ST Editor for VI Enthusiasts)
comes from the fact that the editor was  first	written  for
the  Atari ST. The current version also supports UNIX, Minix
(ST), MS-DOS, and OS/2, but I've left the  name  intact  for
now.

This program is the result of many late  nights  of  hacking
over  the  last  couple  of  years.   The  first version was
written by Tim Thompson and posted to USENET. From there,  I
reworked  the  data  structures  completely,  added  LOTS of
features, and generally improved the overall performance  in
the process.

I've labelled STEVIE an 'aspiring' vi clone as a warning  to
those  who  may expect too much. On the whole, the editor is
pretty complete.  Nearly all of the visual mode commands are
supported.   And several of the more important 'ex' commands
are supported as well.	I've tried hard to capture the	feel
of vi by getting the little things right.  Making lines wrap
correctly, supporting true operators, and even	getting  the
cursor	to  land on the right place for tabs are all a pain,
but really help make the editor feel right.  I've  tried  to
resist	the  temptation  to deviate from the behavior of vi,
even where I disagree with the original design.

The biggest problem remaining has to do with the  fact	that
the  edit  buffer is maintained entirely in memory, limiting
the size of files that can be edited in  some  environments.
Other  missing	features  include  named buffers and macros.
Performance is generally  reasonable,  although  the  screen
update code could be more efficient.  This is generally only
visible on fairly slow systems.

STEVIE	may  be  freely  distributed.	The   source   isn't
copyrighted  or  restricted  in  any  way.  If	you pass the
program along, please include all the documentation and,  if
practical, the source as well. I'm not fanatical about this,
but I tried to make STEVIE fairly portable and I'd  like  to
see as many people have access to the source as possible.

The remainder of this document describes  the  operation  of
the  editor.   This  is  intended  as  a reference for users
already familiar with the real vi editor.



			- 1 -







STEVIE					      User Reference



2.  _S_t_a_r_t_i_n_g__t_h_e__E_d_i_t_o_r

The following command line forms are supported:

stevie [file ...]   Edit the specified file(s)

stevie -t tag	    Start at the location of the given tag

stevie + file	    Edit file starting at end

stevie +n file	    Edit file starting a line number 'n'

stevie +/pat file   Edit file starting at pattern 'pat'

If multiple files are given on the command line  (using  the
first  form),  the  ":n" command goes to the next file, ":N"
goes backward in the list, and ":rew" can be used to  rewind
back to the start of the file list.


3.  _S_e_t__C_o_m_m_a_n_d__O_p_t_i_o_n_s

The ":set" command works as usual to  set  parameters.	Each
parameter  has	a  long  and  an abbreviated name, either of
which may be used. Boolean parameters are set as in:

     set showmatch

or cleared by:

     set noshowmatch

Numeric parameters are set as in:

     set scroll=5

Several parameters may be set with a single command:

     set novb sm report=1

To see the status of all parameters use ":set  all".  Typing
":set"	with  no  arguments  will show only those parameters
that have been changed.   The  supported  parameters,  their
names,	abbreviations,	defaults, and descriptions are shown
below:

autoindent  Short: ai, Default: noai, Type: Boolean
	    When in insert mode, start new lines at the same
	    column  as	the  prior  line. Unlike vi, you can
	    backspace over the indentation.




			- 2 -







STEVIE					      User Reference



backup	    Short: bk, Default: nobk, Type: Boolean
	    Leave a backup on  file  writes.   (During	file
	    writes,  a	backup	is  always  kept  for safety
	    anyway, until the write is completed.   At	that
	    point, the 'backup' parameter determines whether
	    the backup file is deleted.)

color	    Short:  co,  Default:  system-dependent,   Type:
	    Numeric
	    Change  the  screen  color	(video	attributes).
	    There  is  a  system-dependent  mapping  between
	    numbers and colors.  (For instance, in MSDOS  we
	    use   the	BIOS-type   attributes	for  CGA  or
	    monochrome screens in alphanumeric mode.)

errorbells  Short: eb, Default: noeb, Type: Boolean
	    Ring bell when error messages are shown.

ignorecase  Short: ic, Default: noic, Type: Boolean
	    Ignore case in string searches.

lines	    Short: lines, Default: lines=25, Type: Numeric
	    Number of physical	lines  on  the	screen.  The
	    default  value  and  possible settings depend on
	    the host machine.  The default value  is  25  on
	    most systems.

list	    Short: list, Default: nolist, Type: Boolean
	    Show tabs and newlines graphically.

modelines   Short: ml, Default: noml, Type: Boolean
	    Enable processing of modelines in files.

number	    Short: nu, Default: nonu, Type: Boolean
	    Display lines on  the  screen  with  their	line
	    numbers.

report	    Short: report, Default: report=5, Type: Numeric
	    Minimum number of lines to report operations on.

return	    Short: cr, Default: cr, Type: Boolean
	    End lines with cr-lf when writing files.

scroll	    Short: scroll, Default: scroll=12, Type: Numeric
	    Number of lines to scroll for ^D & ^U.

showmatch   Short: sm, Default: nosm, Type: Boolean
	    When a ), }, or ] is typed, show the matching (,
	    {,	or [ if it's on the current screen by moving
	    the cursor there briefly.




			- 3 -







STEVIE					      User Reference



showmode    Short: mo, Default: nomo, Type: Boolean
	    Show on status line when in insert mode.

tabstop     Short: ts, Default: ts=8, Type: Numeric
	    Number of spaces in a tab.

tagstack    Short: tg, Default: notg, Type: Boolean
	    If set, the tag command :ta is  "stacked";	that
	    is, the place from which it was called is pushed
	    onto a stack.  A new command ":untag" goes	back
	    to that place, and pops the tag stack.

terse	    Short: terse, Default: noterse, Type: Boolean
	    This  option  is  currently  ignored.    It   is
	    provided only for compatibility with vi.

tildeop     Short: to, Default: noto, Type: Boolean
	    If set, tilde is an operator.  Otherwise,  tilde
	    acts as normal.

wrapscan    Short: ws, Default: ws, Type: Boolean
	    String searches wrap  around  the  ends  of  the
	    file.

vbell	    Short: vb, Default: vb, Type: Boolean
	    Use  a  visual  bell,  if  possible.  (novb  for
	    audible bell)

The EXINIT environment variable can be used  to  modify  the
default values on startup as in:

     setenv EXINIT="set sm ts=4"

In environments (e.g. OS/2 or TOS) where lines are  normally
terminated  by CR-LF, the 'return' parameter allows files to
be written with only a LF terminator (if  the  parameter  is
cleared).  This parameter is ignored on UNIX systems.

The 'lines' parameter tells the editor how many lines  there
are  on  the  screen.  This is useful on systems like the ST
(or OS/2 machines with an EGA adapter) where various  screen
resolutions  may  be  used.  By using the 'lines' parameter,
different screen sizes can be easily handled.


4.  _C_o_l_o_n__C_o_m_m_a_n_d_s

Several of the normal 'vi' colon commands are  supported  by
STEVIE.   Some	commands  may  be  preceded  by a line range
specification.	For commands that accept a range  of  lines,
the following address forms are supported:



			- 4 -







STEVIE					      User Reference



     addr
     addr + number
     addr - number

where 'addr' may be one of the following:

     a line number
     a mark (as in 'a or 'b)
     '.' (the current line)
     '$' (the last line)

An address range of "%" is accepted as	an  abbreviation  of
"1,$".

4.1  _M_o_d_e__L_i_n_e_s

Mode lines are a little-known, but often useful, feature  of
vi.   To use this feature, special strings are placed in the
first or last five lines  in  a  file.	 When  the  file  is
edited,  these	strings are detected and processed as though
typed as a colon command.  One instance where  this  can  be
useful	is  to	set  the  "tabstop"  parameter on a per-file
basis.	The following are examples of mode lines:

     vi:set ts=4 noai:
     ex:45:

Mode lines are characterized by  the  string  "vi"  or	"ex"
followed  by  a command surrounded by colons. Other text may
appear on the line, and multiple mode lines may be  present.
No  guarantee  is made regarding the order in which multiple
mode lines will be processed.

The processing of mode lines is enabled by setting the	"ml"
parameter.  This  should be done in the "EXINIT" environment
variable, so that mode line processing is enabled as soon as
the  editor begins.  By default, mode lines are disabled for
security reasons.

4.2  _T_h_e__G_l_o_b_a_l__C_o_m_m_a_n_d

A limited form of the global command is supported, accepting
the following command form:

     g/pattern/X

where X may be either 'd' or 'p' to delete  or	print  lines
that  match  the  given  pattern.  If a line range is given,
only those lines are checked for a match with  the  pattern.
If no range is given, all lines are checked.




			- 5 -







STEVIE					      User Reference



If  the  trailing  command  character  is  omitted,  'p'  is
assumed.  In this case, the trailing slash is also optional.
The current version of the editor does not support the	undo
operation  following  the  deletion of lines with the global
command.

4.3  _T_h_e__S_u_b_s_t_i_t_u_t_e__C_o_m_m_a_n_d

The substitute command provides  a  powerful  mechanism  for
making	more complex substitutions than can be done directly
from visual mode.  The general form of the command is:

     s/pattern/replacement/g

Each line in the given range (or the  current  line,  if  no
range	was   given)   is  scanned  for  the  given  regular
expression.  When found, the string that matched the pattern
is  replaced  with  the  given	replacement  string.  If the
replacement string is null, each matching pattern string  is
deleted.

The trailing 'g' is optional and, if present, indicates that
multiple  occurrences  of  'pattern' on a line should all be
replaced.

Some special sequences are  recognized	in  the  replacement
string.  The  ampersand  character is replaced by the entire
pattern  that  was  matched.   For  example,  the  following
command  could	be  used  to put all occurrences of 'foo' or
'bar' within double quotes:

     1,$s/foo|bar/"&"/g

The special sequence "\n" where 'n' is a digit from 1 to  9,
is  replaced  by  the  string  the matched the corresponding
parenthesized  expression  in  the  pattern.  The  following
command  could	be  used to swap the first two parameters in
calls to the C function "foo":

     1,$s/foo\(([^,]*),([^,]*),/foo(\2,\1,/g

Like the global command, substitutions can't be undone	with
this version of the editor.

4.4  _F_i_l_e__M_a_n_i_p_u_l_a_t_i_o_n__C_o_m_m_a_n_d_s

The following table shows the  supported  file	manipulation
commands  as  well  as	some other 'ex' commands that aren't
described elsewhere:





			- 6 -







STEVIE					      User Reference



:w		write the current file
:wq		write and quit
:x		write (if necessary) and quit
ZZ		same as ":x"

:e file         edit the named file
:e!		re-edit the current file, discarding changes
:e #		edit the alternate file

:w file         write the buffer to the named file
:x,yw file	write lines x through y to the named file
:r file         read the named file into the buffer

:n		edit the next file
:N		edit the previous file
:rew		rewind the file list

:f		show the current file name
:f name         change the current file name
:x=		show the line number of address 'x'

:ta tag         go to the named tag
^]		like ":ta" using the current word as the tag
:untag		go back to place from which ":ta" was called

:help		display a command summary
:ve		show the version number

:sh		run an interactive shell
:!cmd		run a command

The commands above work pretty much like they  do  in  'vi'.
Most  of  the commands support a '!' suffix (if appropriate)
to discard any pending changes.


5.  _H_e_l_p_F_a_c_i_l_i_t_y

The ":help" command can also be invoked with the <HELP>  key
on  the Atari ST and the F1 key on MSDOS and OS/2 PCs.	This
actually displays a pretty complete summary of the  real  vi
with  unsupported features indicated appropriately.  Certain
features controlled by "set"  parameters  will	have  varied
displays  on  the Help screens, to correspond to the current
setting of their parameters.

The  help  screens  (there  are  multiple  screens)  can  be
traversed  using "reasonable" keystrokes.  For instance, any
key that would take you "down" in the vi editor,  will	take
you   to   the	next  help  screen  in	the  help  facility.
Similarly, "up" commands  will	take  you  to  the  previous



			- 7 -







STEVIE					      User Reference



screen.  The  screens are numbered, and any numeric key will
take you to the  corresponding	screen.   The  first  screen
(screen 0) is a table of contents for the help screens.


6.  _S_t_r_i_n_g__S_e_a_r_c_h_e_s

String searches are supported, as in vi, accepting the usual
regular  expression  syntax.  This was done using a modified
form of Henry Spencer's regular expression library. I  added
code  outside  the  library  to  support  the  '\<' and '\>'
extensions.  The parameter "ignorecase" can be set to ignore
case in all string searches.


7.  _O_p_e_r_a_t_o_r_s

The vi operators (d, c,  y,  !,  <,  and  >)  work  as	true
operators.   The  tilde  command  may  also  be  used  as an
operator  if  the  parameter  "tildeop"  has  been  set.  By
default, this parameter is not set.


8.  _T_a_g_s

Tags are implemented and a fairly simple version of  'ctags'
is  supplied  with  the editor. The current version of ctags
will find functions and macros	following  a  specific	(but
common) form.  See 'ctags.doc' for a complete discussion.

A non-standard but useful variant of tags is the  "stacking"
of calls to the ':ta' command.	When tag-stacking is enabled
(with ':set tg'), stevie remembers (and stacks) the position
from  which  any  tag  call  is  made.	 In this mode, a new
':untag' command returns to the remembered position and pops
the  stack.   Also  while  in  the tagstack mode, the Ctrl-^
keystroke  has	a  somewhat  different	effect.   Before  it
switches  to  edit the alternate file (its normal function),
it checks to see if the tag stack  is  empty,  and  does  an
':untag' if not empty.


9.  _S_y_s_t_e_m_-_S_p_e_c_i_f_i_c__C_o_m_m_e_n_t_s

The   following   sections   provide   additional   relevant
information for the systems to which STEVIE has been ported.
(WARNING: If you compile Stevie for, or port Stevie to, your
favorite   environment,   don't  forget  to  edit  ENV.H  to
correspond to the target environment.)





			- 8 -







STEVIE					      User Reference



9.1  _A_t_a_r_i__S_T

9.1.1  _T_O_S   The  editor  has  been  tested  in  all   three
resolutions, although low and high res. are less tested than
medium. The 50-line high res. mode can be  used  by  setting
the  'lines' parameter to 50. Alternatively, the environment
variable 'LINES' can be set. The editor doesn't actively set
the  number  of  lines on the screen. It just operates using
the number of lines it was told.

The arrow keys, as well as the <INSERT>, <HELP>, and  <UNDO>
keys are all mapped appropriately.

9.1.2  _M_i_n_i_x  The editor  is  pretty  much  the  same  under
Minix,	 but  many  of	the  keyboard  mappings  aren't  yet
supported.

9.2  _U_N_I_X

The editor has been ported to UNIX System  V  release  3  as
well as 4.2 BSD.  This was done mainly to get some profiling
data so I haven't  put	much  effort  into  doing  the	UNIX
version  right.   While  the termcap routines are supported,
the editor is still fairly picky about the  capabilities  it
wants  and makes little effort to do clever things with less
intelligent terminals.

9.3  _O_S_/_2

This port was done because the editor that  comes  with  the
OS/2 developer's kit really stinks. Make sure 'ansi' mode is
on (using the 'ansi'  command).   The  OS/2  console  driver
doesn't  support  insert/delete line, so STEVIE bypasses the
driver and makes  the  appropriate  system  calls  directly.
This  is  all done in the system-specific part of the editor
so the kludge is at least localized.

The arrow keys, page up/down and home/end all do what  you'd
expect.  The  function	keys  are  hard-coded to some useful
macros until I can get true  support  for  macros  into  the
editor. The current mappings are:













			- 9 -







STEVIE					      User Reference



     F1    Help
     F2    Next file (:n)	      Shift-F2	discard changes (:n!)
     F3    Previous file (:N)	      Shift-F3	discard changes (:N!)
     F4    Alternate file (:e #)      Shift-F4	discard changes (:e! #)
     F5    Rewind file list (:rew)    Shift-F5	discard changes (:rew!)
     F6    Next function (]])	      Shift-F6	Prev. function ([[)
     F8    Global subst. (:1,$s/)
     F9    Convert cdecl to English   Shift-F9	Convert English to cdecl
     F10   Save & quit (:x)	      Shift-F10 discard changes (:q!)

Function keys F9 and Shift-F9 assume  the  presence  of  the
cdecl program.

9.4  _M_S_D_O_S

STEVIE has been ported to MSDOS 3.3 using (1) the  Microsoft
C  compiler,  version  5.1,  and  (2)  the  Borland  Turbo C
compiler, version 2.0.

The keyboard mappings are the same as for  OS/2.   The	only
problem  with the PC version is that the inefficiency of the
screen update code  becomes  painfully	apparent  on  slower
machines.   (In  Rev  3.69a,  there  are a couple of ways in
which screen I/O is significantly speeded up.)

There are two  DOS  versions:  one  that  uses	an  extended
console  driver,  and  another	that uses the BIOS directly.
The  extended-console-driver   version	 works	 well	with
"nansi.sys",  which  is widely available shareware.  It does
not work well with the "ANSI.SYS" driver included as part of
MSDOS  (at  least through the 3.30 version).  In order to be
independent of the console driver, you may compile with BIOS
#defined;  this  uses  the  BIOS as the exclusive screen I/O
mechanism.   (Note  that  it   is   somewhat   slower	than
nansi.sys.)

The  color  settings  are  the	video  attributes  for	 the
alphanumeric  modes  of  the  CGA  and	monochrome displays.
While these make most sense in binary or hex, they  must  be
entered  in  decimal.  The reference table below gives a few
common values:

     07    White on black	   Initial default
     23    White on blue
     30    Bright yellow on blue   My favorite









			- 10 -







STEVIE					      User Reference



10.  _M_i_s_s_i_n_g__F_e_a_t_u_r_e_s

  1.  The ability to edit files larger	than  the  available
      memory.	This  isn't a problem on the machines I use,
      but it hits the Minix-PC people pretty hard.

  2.  Macros with support for function keys.

  3.  More "set" options.

  4.  Many others...


11.  _K_n_o_w_n__B_u_g_s__a_n_d__P_r_o_b_l_e_m_s

  1.  The yank buffer uses statically allocated  memory,  so
      large  yanks  will  fail.  If  a	delete spans an area
      larger than the yank  buffer,  the  program  asks  for
      confirmation  before proceeding. That way, if you were
      moving text, you don't get screwed by the limited yank
      buffer.  You  just  have	to  move smaller chunks at a
      time. All the internal buffers (yank, redo, etc.) need
      to  be  reworked	to  allocate memory dynamically. The
      'undo' buffer is now  dynamically  allocated,  so  any
      change can be undone.

  2.  If you stay in insert mode for a long time, the insert
      buffer  can overflow.  The editor will print a message
      and dump you back into command mode.

  3.  The current  version  of	the  substitute  and  global
      commands	(i.e.  ":s/foo/bar"  or ":g/foo/d") can't be
      undone.  This is due to the current design of the undo
      code.   To undo these commands would generally involve
      unreasonable amounts of memory.

  4.  Several other less bothersome glitches...

















			- 11 -







STEVIE					      User Reference



12.  _C_o_n_c_l_u_s_i_o_n

The editor has reached a pretty stable state,  and  performs
well  on  the  systems	I  use	it on, so I'm pretty much in
maintenance mode now.  There's still plenty to be done;  the
screen	update	code  is  still  pretty  inefficient and the
yank/put code is still primitive.  I'm still  interested  in
bug  reports,  and I do still add a new feature from time to
time, but the rate of change is way down now.

I'd like to thank Tim  Thompson  for  writing  the  original
version  of  the editor. His program was well structured and
quite readable. Thanks for giving me a	good  base  to	work
with.	Thanks also to many users of STEVIE who have sent in
their changes.	Many of the  changes  I've  received  aren't
portable  to  all  the systems I support, but I'm working to
get portable  implementations  integrated  into  the  editor
where possible.

If you're reading this file, but didn't get the source	code
for  STEVIE,  it  can  be  had by sending a disk with return
postage to the address given below. I can  write  disks  for
the  Atari  ST (SS or DS) or MSDOS (360K or 1.2M). Please be
sure to include the return postage. I don't intend  to	make
money  from  this  program,  but  I  don't  want to lose any
either.

     Tony Andrews	     UUCP: onecom!wldrdg!tony
     5902E Gunbarrel Ave.
     Boulder, CO 80301

     3.69a Additions from
     Dave Tutelman	     UUCP: pegasus.att.com!dmt
     Larry Shurr (The BIOS implementation)




















			- 12 -







STEVIE					      User Reference



_C_h_a_r_a_c_t_e_r__F_u_n_c_t_i_o_n__S_u_m_m_a_r_y

The following list describes the meaning of  each  character
that's	used  by  the  editor. In some cases characters have
meaning in both command  and  insert  mode;  these  are  all
described.


^@	The null character.  Not  used	in  any  mode.	This
	character  may not be present in the file, as is the
	case with vi.

^B	Backward one screen.

^D	Scroll the window down one half screen.

^E	Scroll the screen up one line.

^F	Forward one screen.

^G	Same as ":f" command. Displays file information.

^H	(Backspace) Moves cursor left one space  in  command
	mode.	In  insert  mode,  erases the last character
	typed.

^J	Move the cursor down one line.

^L	Clear and redraw the screen.

^M	(Carriage  return)  Move  to  the  first   non-white
	character  in  the  next  line.  In  insert  mode, a
	carriage return opens a new line for input.

^N	Move the cursor down a line.

^P	Move the cursor up a line.

^U	Scroll the window up one half screen.

^Y	Scroll the screen down one line.

^[	Escape cancels a pending command  in  command  mode,
	and is used to terminate insert mode.

^]	Moves to the tag whose name is given by the word  in
	which the cursor resides.

^`	Same as ":e #" if supported (system-dependent).





			- 13 -







STEVIE					      User Reference



SPACE	Move the cursor right on column.

!	The filter operator always operates on	a  range  of
	lines,	passing the lines as input to a program, and
	replacing them with the output of the  program.  The
	shorthand  command  "!!"  can  be  used  to filter a
	number of lines (specified by  a  preceding  count).
	The  command  "!"  is  replaced  by the last command
	used, so "!!!<RETURN>"	runs  the  given  number  of
	lines through the last specified command.

$	Move to the end of the current line.

%	If the cursor rests on a paren '()', brace '{}',  or
	bracket '[]', move to the matching one.

'	Used to move  the  cursor  to  a  previously  marked
	position,  as  in  'a or 'b. The cursor moves to the
	start of the marked line. The special mark '' refers
	to the "previous context".

+	Same as carriage return, in command mode.

,	Reverse of the last t, T, f, or F command.

-	Move  to  the  first  non-white  character  in	 the
	previous line.

.	Repeat the last edit command.

/	Start of a forward  string  search  command.  String
	searches may be optionally terminated with a closing
	slash. To search for a slash use '\/' in the  search
	string.

0	Move to the start of the  current  line.  Also	used
	within counts.

1-9	Used to add 'count' prefixes to commands.

:	Prefix character for "ex" commands.

;	Repeat last t, T, f, or F command.

<	The 'left shift' operator.

>	The 'right shift' operator.

?	Same as '/', but search backward.





			- 14 -







STEVIE					      User Reference



A	Append at the end of the current line.

B	Backward one blank-delimited word.

C	Change the rest of the current line.

D	Delete the rest of the current line.

E	End of the end of a blank-delimited word.

F	Find a character backward on the current line.

G	Go to  the  given  line  number  (end  of  file,  by
	default).

H	Move to the first non-white char. on the top  screen
	line.

I	Insert before  the  first  non-white  char.  on  the
	current line.

J	Join two lines.

L	Move to the first  non-white  char.  on  the  bottom
	screen line.

M	Move to the first  non-white  char.  on  the  middle
	screen line.

N	Reverse the last string search.

O	Open a new line above the current  line,  and  start
	inserting.

P	Put the yank/delete buffer before the current cursor
	position.

R	Replace characters until an  "escape"  character  is
	received.   Similar  to  insert  mode,	but replaces
	instead of inserting.  Typing a newline  in  replace
	mode  is  the  same as in insert mode, but replacing
	continues on the new line.

T	Reverse search 'upto' the given character.

U	Restore the current line to  its  state  before  you
	started changing it.

W	Move forward one blank-delimited word.





			- 15 -







STEVIE					      User Reference



X	Delete one character before the cursor.

Y	Yank the current line. Same as 'yy'.

ZZ	Exit from the editor, saving changes if necessary.

[[	Move backward one C function.

]]	Move forward one C function.

^	Move to the first non-white on the current line.

`	Move to the given mark, as with '.  The  distinction
	between the two commands is important when used with
	operators. I support the  difference  correctly.  If
	you  don't know what I'm talking about, don't worry,
	it won't matter to you.

a	Append text after the cursor.

b	Back one word.

c	The change operator.

d	The delete operator.

e	Move to the end of a word.

f	Find a character on the current line.

h	Move left one column.

i	Insert text before the cursor.

j	Move down one line.

k	Move up one line.

l	Move right one column.

m	Set a mark at the current position (e.g. ma or mb).

n	Repeat the last string search.

o	Open a new line and start inserting text.

p	Put the yank/delete buffer after the cursor.

r	Replace a character.





			- 16 -







STEVIE					      User Reference



s	Replace characters.

t	Move forward  'upto'  the  given  character  on  the
	current line.

u	Undo the last edit.

w	Move forward one word.

x	Delete the character under the cursor.

y	The yank operator.

z	Redraw the screen with the current line at  the  top
	(zRETURN), the middle (z.), or the bottom (z-).

|	Move to the column given by the preceding count.

~	Invert the case of the current character (if  alpha)
	and  move  to the right.  If the parameter "tildeop"
	is set, this command functions as an operator.

































			- 17 -











		    STEVIE - User Guide

			  CONTENTS


 1.  Overview				1

 2.  Starting the Editor		2

 3.  Set Command Options		2

 4.  Colon Commands			4
     4.1  Mode Lines			5
     4.2  The Global Command		5
     4.3  The Substitute Command	6
     4.4  File Manipulation Commands	6

 5.  Help				7

 6.  String Searches			8

 7.  Operators				8

 8.  Tags				8

 9.  System-Specific Comments		8
     9.1  Atari ST			9
     9.2  UNIX				9
     9.3  OS/2				9
     9.4  MSDOS				10

10.  Missing Features			11





			   - i -











11.  Known Bugs and Problems		11

12.  Conclusion				12

Character Function Summary		13












































			   - ii -
