# Makefile for flip for **IX.  ::[[ @(#) makefile.nix 1.4 89/07/04 12:00:02 ]]::

# The contents of this makefile are hereby released to the public domain.
#                               -- Rahul Dhesi 1989/06/19

# Before use make sure this file is called "makefile".  (Rename it if
# necessary.)  Then invoke as follows:

#   "make sys_v"        makes executable flip for System V Release 2
#   "make bsd"          makes executable flip for 4.3BSD
#   "make install"      moves flip into BINDIR, copies flip.1 into MANDIR
#   "make clean"        deletes object and executable files

# Where to install executable and manual files on "make install".  The trailing
# "/." forces an error message if the destination directory doesn't exist.
BINDIR = /usr/local/bin/.
MANDIR = /usr/man/man1/.

# CC is compiler, LD is loader (may be same as compiler), CFLAGS are flags
# for compiler, LDFLAGS are flags for loader, CFMORE are additional
# (relatively unchanging) flags for compiler

CC = cc
CFLAGS =
CFMORE = -c -DNDEBUG -O
LD = cc
LDFLAGS = -o flip

# If your system does not supply getopt as a library function,
# add getopt.o to the RHS list on the next line and uncomment the
# two nonblank lines after that.
OBJS = flip.o

#getopt.o: getopt.c flip.h
#	$(CC) $(CFLAGS) $(CFMORE) $*.c

nothing:
	@echo \
	'Please type "make sys_v", "make bsd", "make uport", or "make ultrix"'

sys_v:
	make "CFLAGS=-DSYS_V" flip

uport:
	make "CFLAGS=-DSYS_V -Ml" "LDFLAGS=-Ml -o flip" flip

bsd:
	make "CFLAGS=-DBSD" flip

ultrix:
	make "CFLAGS=-DBSD -DULTRIX_BUG" flip

flip: $(OBJS)
	$(LD) $(LDFLAGS) $(OBJS)

flip.o: flip.c flip.h
	$(CC) $(CFLAGS) $(CFMORE) $*.c

clean:
	rm -f *.o core flip

install:
	mv flip $(BINDIR)
	cp flip.1 $(MANDIR)
